% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_tests.R
\name{is_clade}
\alias{is_clade}
\title{Test if a lineage belongs to a clade}
\usage{
is_clade(lineage, clade, rank = c(".", "kingdom", "phylum", "class",
  "order", "family", "genus", "species", "strain"))
}
\arguments{
\item{lineage}{string. Vector of lineages.}

\item{clade}{string.}

\item{rank}{string. One of \code{c("kingdom", "phylum", "class",
"order", "family", "genus", "species", "strain")} with partial matching.}
}
\value{
logical.
}
\description{
Test if a lineage belongs to a clade
}
\details{
If \code{rank} is set to \code{.}, clade is looked for among all ranks.
}
\examples{
lineage1 <- "k__Bacteria|p__Verrucomicrobia|c__Verrucomicrobiae"
lineage2 <- "k__Bacteria|p__Firmicutes|c__Clostridia"
is_clade(c(lineage1, lineage2), clade = "Verrucomicrobia", rank = "phylum")
is_clade(c(lineage1, lineage2), clade = "Clostridia")
}
