% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxtree.R
\name{taxtree}
\alias{taxtree}
\title{Taxonomic tree}
\usage{
taxtree(table, collapse = TRUE, lineage_length = 1, root = "")
}
\arguments{
\item{table}{dataframe.}

\item{collapse}{logical. Should node with one child be vanished? Default
to TRUE.}

\item{lineage_length}{double. Lineage length from the root to the leaves.
Default to 1.}

\item{root}{character. Name of the root if there is no natural root.}
}
\value{
A phylo object.
}
\description{
Compute taxonomic tree from taxonomic table.
}
\examples{
lineage1 <- "k__Bacteria|p__Verrucomicrobia|c__Verrucomicrobiae"
lineage2 <- "k__Bacteria|p__Firmicutes|c__Clostridia"
lineage3 <- "k__Bacteria|p__Firmicutes|c__Bacilli"
table <- taxtable(c(lineage1, lineage2, lineage3))
taxtree(table)
}
