% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim_rank}
\alias{trim_rank}
\title{Trim lineages until a specified rank}
\usage{
trim_rank(
  lineage,
  rank = c("kingdom", "phylum", "class", "order", "family", "genus", "species", "strain"),
  same = TRUE
)
}
\arguments{
\item{lineage}{string. Vector of lineages.}

\item{rank}{string. One of \code{c("kingdom", "phylum", "class",
"order", "family", "genus", "species", "strain")} with partial matching.}

\item{same}{logical. Does the lineage have the same depth? Default to TRUE.}
}
\value{
The trimmed lineages. Depth could be different among them.
}
\description{
Trim lineages until a specified rank
}
\details{
Returns \code{NA} if a lineage is not as deep as the specified rank.
}
\examples{
lineage1 <- "k__Bacteria|p__Verrucomicrobia|c__Verrucomicrobiae"
lineage2 <- "k__Bacteria|p__Firmicutes|c__Clostridia"
trim_rank(c(lineage1, lineage2), rank = "phylum")
trim_rank(c(lineage1, lineage2), rank = "genus")
}
