% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textual.R
\name{textInput}
\alias{textInput}
\alias{numberInput}
\alias{updateTextInput}
\alias{groupTextInput}
\alias{updateGroupTextInput}
\title{Text inputs}
\usage{
textInput(id, value = NULL, placeholder = NULL, ..., type = "text")

numberInput(id, value = NULL, placeholder = NULL, ..., min = NULL,
  max = NULL, step = 1)

updateTextInput(id, value = NULL, enable = NULL, disable = NULL,
  valid = NULL, invalid = NULL, session = getDefaultReactiveDomain())

groupTextInput(id, value = NULL, placeholder = NULL, ...,
  type = "text", left = NULL, right = NULL)

updateGroupTextInput(id, value = NULL, enable = NULL, disable = NULL,
  valid = NULL, invalid = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{value}{A character string or a value coerced to a character string
specifying the default value of the textual input.}

\item{placeholder}{A character string specifying placeholder text for the
input, defaults to \code{NULL}, in which case there is no placeholder text.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{type}{One of "\code{color}", "\code{date}", "\code{datetime-local}", "\code{email}", "\code{month}", "\code{number}", "\code{password}", "\code{search}", "\code{tel}", "\code{text}", "\code{time}", "\code{url}" or "\code{week}" specifying the type of text input, defaults to \code{"text"}.

For details on a particular type please see \url{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input}.}

\item{min}{A number specifying the minimum allowed value of the number input,
defaults to \code{NULL}.}

\item{max}{A number specifying the maximum allowed value of the number input,
defaults to \code{NULL}.}

\item{step}{A number specifying the increment step of the number input,
defaults to 1.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{valid}{A character string specifying a message to the user indicating
how the input's value is valid, defaults to \code{NULL.}}

\item{invalid}{A character string specifying a message to the user
indicating how the input's value is invalid, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}

\item{left}{A character vector specifying static addons or
\code{\link[=buttonInput]{buttonInput()}} or \code{\link[=dropdown]{dropdown()}} elements specifying dynamic addons. Addons
affect the reactive value of the group input, see the Details section below
for more information.

\strong{\code{left} is character or \code{right} is character}

If \code{left} or \code{right} are character vectors, then the group input functions
like a text input. The value will update and trigger a reactive event when
the text box is modified. The group input's reactive value is the
concatention of the static addons specified by \code{left} or \code{right} and the
value of the text input.

\strong{\code{left} is button or \code{right} is button}

The button does not change the value of the group input. However, the input
no longer triggers event when the text box is updated. Instead the value is
updated when a button is clicked. Static addons are still applied to the
group input value.

\strong{\code{left} is a dropdown or \code{right} is a dropdown}

The value of the group input does chance depending on the clicked dropdown
menu item. The value of the input group is the concatentation of the
dropdown input value, the value of the text input, and any static addons.}

\item{right}{A character vector specifying static addons or
\code{\link[=buttonInput]{buttonInput()}} or \code{\link[=dropdown]{dropdown()}} elements specifying dynamic addons. Addons
affect the reactive value of the group input, see the Details section below
for more information.

\strong{\code{left} is character or \code{right} is character}

If \code{left} or \code{right} are character vectors, then the group input functions
like a text input. The value will update and trigger a reactive event when
the text box is modified. The group input's reactive value is the
concatention of the static addons specified by \code{left} or \code{right} and the
value of the text input.

\strong{\code{left} is button or \code{right} is button}

The button does not change the value of the group input. However, the input
no longer triggers event when the text box is updated. Instead the value is
updated when a button is clicked. Static addons are still applied to the
group input value.

\strong{\code{left} is a dropdown or \code{right} is a dropdown}

The value of the group input does chance depending on the clicked dropdown
menu item. The value of the input group is the concatentation of the
dropdown input value, the value of the text input, and any static addons.}
}
\description{
A text input. A group text input is an alternative text input. The group text
input allows you to include static prefixes or buttons with a standard text
input.

\code{numberInput()} is a simple wrapper around \code{textInput()} with \code{type} set to
\code{"number"} and explicit arguments for specifying a min value, max value, and
the step amount. Use \code{updateTextInput()} to update a number input.
}
\examples{

### Default text input

textInput(id = "text")

### Default number input

numberInput(id = "num1")

### Specify `min`, `max`, and `step`

numberInput(
  id = "num2",
  min = 1,
  max = 10,
  step = 2
)

}
\seealso{
Other inputs: \code{\link{buttonGroupInput}},
  \code{\link{buttonInput}}, \code{\link{checkbarInput}},
  \code{\link{checkboxInput}}, \code{\link{chipInput}},
  \code{\link{fileInput}}, \code{\link{formInput}},
  \code{\link{listGroupInput}}, \code{\link{menuInput}},
  \code{\link{navInput}}, \code{\link{radioInput}},
  \code{\link{radiobarInput}}, \code{\link{rangeInput}},
  \code{\link{selectInput}}
}
\concept{inputs}
