% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{font}
\alias{font}
\title{Font color, size, weight}
\usage{
font(tag, color = NULL, size = NULL, weight = NULL, case = NULL,
  align = NULL)
}
\arguments{
\item{tag}{A tag element.}

\item{color}{One of "\code{red}", "\code{purple}", "\code{indigo}", "\code{blue}", "\code{cyan}", "\code{teal}", "\code{green}", "\code{yellow}", "\code{amber}", "\code{orange}", "\code{grey}", "\code{black}" or "\code{white}" specifying the text color of the tag element, defaults to \code{NULL}}

\item{size}{One of \code{"xs"}, \code{"sm"}, \code{"base"}, \code{"lg"}, \code{"xl"} specifying a font
size relative to the default base page font size, defaults to \code{NULL}.}

\item{weight}{One of \code{"bold"}, \code{"normal"}, \code{"light"}, \code{"italic"}, or
\code{"monospace"} specifying the font weight of the element's text, defaults to
\code{NULL}.}

\item{case}{One of \code{"upper"}, \code{"lower"}, or \code{"title"} specifying a
transformation of the tag element's text, default to \code{NULL}.}

\item{align}{A \link{responsive} argument. One of \code{"left"}, \code{"center"}, \code{"right"},
or \code{"justify"}, specifying the alignment of the tag element's text, defaults
to \code{NULL}.}
}
\description{
The \code{font()} utility modifies the color, size, weight, case, or alignment of
a tag element's text. All arguments default to \code{NULL}, in which case they are
ignored.  For example, \code{font(.., size = "lg")} increases font size without
affecting color, weight, case, or alignment.
}
\examples{

### Changing text color

card(
  header = h3("Important!") \%>\%
    font(color = "amber"),
  div(
    "This is a reminder."
  )
) \%>\%
  border(color = "amber")

### Changing font size

div(
  p("Extra small") \%>\%
    font(size = "xs"),
  p("Small") \%>\%
    font(size = "sm"),
  p("Medium") \%>\%
    font(size = "base"),
  p("Large") \%>\%
    font(size = "lg"),
  p("Extra large") \%>\%
    font(size = "xl")
)

### Changing font weight

# Make an element's text bold, italic, light, or monospace.

p("Curabitur lacinia pulvinar nibh.") \%>\%
  font(weight = "bold")

p("Proin quam nisl, tincidunt et.") \%>\%
  font(weight = "light")

}
\seealso{
Other design utilities: \code{\link{active}},
  \code{\link{affix}}, \code{\link{background}},
  \code{\link{border}}, \code{\link{display}},
  \code{\link{float}}, \code{\link{height}},
  \code{\link{padding}}, \code{\link{scroll}},
  \code{\link{shadow}}, \code{\link{width}}
}
\concept{design utilities}
