% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toast.R
\name{toast}
\alias{toast}
\alias{showToast}
\alias{closeToast}
\title{Toasts}
\usage{
toast(header, ...)

showToast(toast, duration = 4, action = NULL,
  session = getDefaultReactiveDomain())

closeToast(session = getDefaultReactiveDomain())
}
\arguments{
\item{header}{A character string or tag element specifying a header for the
toast, defaults to \code{NULL}. A close button is always included in the
header.}

\item{...}{Any number of character strings or tag elements to include in the
body of the toast.

Any number of named arguments passed as HTML attributes to the parent
element.}

\item{toast}{A toast element, typically built with \code{toast()}.}

\item{duration}{A positive integer or \code{NULL} specifying the duration of the
toast in seconds by default a toast is removed after 4 seconds. If \code{NULL}
the toast is not automatically removed.}

\item{action}{A character string specifying a reactive id. If specified, the
hiding or closing of the toast will set the reactive id \code{action} to \code{TRUE}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
Send notifications to the user. Create notification elements, toasts, with
the \code{toast()} function. Display toasts with \code{showToast()} and remove all
active toasts with \code{closeToast()}.
}
\section{Showing notifications}{
\preformatted{ui <- container(
  buttonInput(
    id = "show",
    label = "Show notification"
  ) \%>\%
    margin(3)
)

server <- function(input, output) {
  observeEvent(input$show, {
    showToast(
      toast(
        list(
          span("Notification") \%>\%
            margin(right = "4"),
          span(strftime(Sys.time(), "\%H:\%M")) \%>\%
            margin(right = 1)
        ),
        "This is notification ", input$show
      ) \%>\%
        margin(right = 2, top = 2)
    )
  })
}

shinyApp(ui, server)
}
}

\section{Reacting to notifications}{


When a notification is not automatically closed you may want to know
when the notification is manually closed.\preformatted{ui <- container(
  buttonInput(
    id = "show",
    label = "Show notification"
  ) \%>\%
    margin(3)
)

server <- function(input, output) {
  observeEvent(input$show, {
    showToast(
      action = "undo",
      duration = NULL,
      toast(
        tags$strong("Close") \%>\%
          margin(right = "auto"),
        "When closing this notification, see the console"
      ) \%>\%
        margin(right = 2, top = 2)
    )
  })

  observeEvent(input$undo, {
    print("The notification was closed")
  })
}

shinyApp(ui, server)
}
}

\examples{

### A simple toast

# The `"fade"` and `"show"` classes have been added for the sake of
# these examples.

toast(
  class = "fade show",
  header = div("Header") \%>\%
    margin(right = "auto"),
  "Hello, world!"
)

### Styling pieces of a toast

toast(
  class = "fade show",
  list(
    div("Notification") \%>\%
      font(weight = "bold") \%>\%
      margin(right = "auto"),
    tags$small("1 min ago")
  ),
  "Hello, world!"
)

}
\seealso{
Other components: \code{\link{alert}}, \code{\link{badge}},
  \code{\link{blockquote}}, \code{\link{card}},
  \code{\link{collapsePane}}, \code{\link{d1}},
  \code{\link{dropdown}}, \code{\link{img}},
  \code{\link{jumbotron}}, \code{\link{modal}},
  \code{\link{navContent}}, \code{\link{popover}},
  \code{\link{pre}}
}
\concept{components}
