% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{background}
\alias{background}
\title{Background color}
\usage{
background(tag, color)
}
\arguments{
\item{tag}{A tag element.}

\item{color}{One of "\code{red}", "\code{purple}", "\code{indigo}", "\code{blue}", "\code{cyan}", "\code{teal}", "\code{green}", "\code{yellow}", "\code{amber}", "\code{orange}", "\code{grey}", "\code{black}" or "\code{white}" specifying the background color of the tag element, defaults to \code{NULL}}
}
\description{
Use \code{background()} to modify the background color of a tag element.
}
\examples{

### Modifying input elements

checkbarInput(
  id = "bar1",
  choices = c(
    "Nunc rutrum turpis sed pede.",
    "Etiam vel neque.",
    "Lorem ipsum dolor sit amet."
  )
) \%>\%
  background("cyan")

### Possible colors

colors <- c(
  "red", "purple", "indigo", "blue", "cyan", "teal", "green",
  "yellow", "amber", "orange", "grey", "white"
)

div(
  lapply(
    colors,
    background,
    tag = div() \%>\%
      padding(5) \%>\%
      margin(2)
  )
) \%>\%
  display("flex") \%>\%
  flex(wrap = TRUE)

}
\seealso{
Other design utilities: 
\code{\link{active}()},
\code{\link{affix}()},
\code{\link{border}()},
\code{\link{display}()},
\code{\link{float}()},
\code{\link{font}()},
\code{\link{height}()},
\code{\link{padding}()},
\code{\link{scroll}()},
\code{\link{shadow}()},
\code{\link{width}()}
}
\concept{design utilities}
