% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{display}
\alias{display}
\title{Display property}
\usage{
display(tag, type)
}
\arguments{
\item{tag}{A tag element.}

\item{type}{A \link{responsive} argument. One of \code{"inline"}, \code{"block"},
\code{"inline-block"}, \code{"flex"}, \code{"inline-flex"}, or \code{"none"}.}
}
\description{
Use the \code{display()} utility to adjust how a tag element is rendered. All
arguments are responsive allowing you to hide elements on small screens or
convert elements from inline to block on large screens.
}
\examples{

### Using flexbox

# When using `flex()` be sure to set the display, too.

div(
  lapply(
    1:5,
    function(i) {
      div() \%>\%
        padding(5) \%>\%
        margin(top = c(xs = 2), bottom = c(xs = 2)) \%>\%
        background("blue")
    }
  )
) \%>\%
  display("flex") \%>\%
  flex(
    direction = c(xs = "column", sm = "row"),
    justify = c(sm = "around")
  )

}
\seealso{
Other design utilities: 
\code{\link{active}()},
\code{\link{affix}()},
\code{\link{background}()},
\code{\link{border}()},
\code{\link{float}()},
\code{\link{font}()},
\code{\link{height}()},
\code{\link{padding}()},
\code{\link{scroll}()},
\code{\link{shadow}()},
\code{\link{width}()}
}
\concept{design utilities}
