% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{yotov_db_download}
\alias{yotov_db_download}
\title{Download the Yotov database to your local computer}
\usage{
yotov_db_download(
  tag = NULL,
  destdir = tempdir(),
  cleanup = TRUE,
  verbose = interactive()
)
}
\arguments{
\item{tag}{What release tag of data to download. Defaults to the most recent.
Releases are expected to come twice per year. See all releases at
\url{https://github.com/pachamaltese/yotover/releases}.}

\item{destdir}{Where to download the compressed file.}

\item{cleanup}{Whether to delete the compressed file after loading into the database.}

\item{verbose}{Whether to display messages and download progress}
}
\description{
This command downloads the Yotov trade database and populates a local
database. The download is 31.4 MB, and the database uses 3 GB on disk.
During import over 3.5 GB of disk space may be used temporarily.
}
\details{
The database is stored by default under \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}, or its
location can be set with the environment variable \code{YOTOV_DB_DIR}.
}
\examples{
\donttest{
\dontrun{
yotov_db_download()
}
}
}
