% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast2zoocat.R
\name{cast2zoomly}
\alias{cast2zoomly}
\title{Cast a data frame to a \code{zoomly} object}
\usage{
cast2zoomly(x, ...)
}
\arguments{
\item{x}{a data frame containing a column named "month".}

\item{...}{other arguments for cast2zoocat.}
}
\value{
a "\code{zoomly}" object.
}
\description{
Cast a data frame to a "\code{zoomly}" object.
}
\examples{
df <- data.frame(year = rep(1991 : 1995, each = 24), month = rep(1 : 12, 10),
                 varname = rep(c('a', 'b'), each = 12), city = rep(1 : 3, each = 40),
                 value = 1 : 120)
cast2zoomly(df, index.var = 'year', value.var = 'value')

}

