

























#![doc(test(
    no_crate_inject,
    attr(
        deny(warnings, rust_2018_idioms),
        allow(dead_code, unused_assignments, unused_variables)
    )
))]
#![warn(
    missing_docs,
    missing_debug_implementations,
    rust_2018_idioms,
    unreachable_pub
)]
#![cfg_attr(not(feature = "std"), no_std)]

#[cfg(crossbeam_loom)]
#[allow(unused_imports)]
mod primitive {
    pub(crate) mod sync {
        pub(crate) mod atomic {
            pub(crate) use loom::sync::atomic::spin_loop_hint;
            pub(crate) use loom::sync::atomic::{
                AtomicBool, AtomicI16, AtomicI32, AtomicI64, AtomicI8, AtomicIsize, AtomicU16,
                AtomicU32, AtomicU64, AtomicU8, AtomicUsize,
            };






            pub(crate) use loom::sync::atomic::fence as compiler_fence;
        }
        pub(crate) use loom::sync::{Arc, Condvar, Mutex};
    }
}
#[cfg(not(crossbeam_loom))]
#[allow(unused_imports)]
mod primitive {
    pub(crate) mod sync {
        pub(crate) mod atomic {
            pub(crate) use core::sync::atomic::compiler_fence;


            #[allow(deprecated)]
            pub(crate) use core::sync::atomic::spin_loop_hint;
            #[cfg(not(crossbeam_no_atomic))]
            pub(crate) use core::sync::atomic::{
                AtomicBool, AtomicI16, AtomicI32, AtomicI8, AtomicIsize, AtomicU16, AtomicU32,
                AtomicU8, AtomicUsize,
            };
            #[cfg(not(crossbeam_no_atomic_64))]
            pub(crate) use core::sync::atomic::{AtomicI64, AtomicU64};
        }

        #[cfg(feature = "std")]
        pub(crate) use std::sync::{Arc, Condvar, Mutex};
    }
}

pub mod atomic;

mod cache_padded;
pub use crate::cache_padded::CachePadded;

mod backoff;
pub use crate::backoff::Backoff;

use cfg_if::cfg_if;

cfg_if! {
    if #[cfg(feature = "std")] {
        pub mod sync;

        #[cfg(not(crossbeam_loom))]
        pub mod thread;
    }
}
