% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bekk_fit_methods.R
\name{print.bekkFit}
\alias{print.bekkFit}
\alias{residuals.bekkFit}
\alias{logLik.bekkFit}
\title{bekkFit method}
\usage{
\method{print}{bekkFit}(x, ...)

\method{residuals}{bekkFit}(object, ...)

\method{logLik}{bekkFit}(object, ..., k = 2)
}
\arguments{
\item{x}{An object of class "bekkFit" from function \link{bekk_fit}.}

\item{...}{Further arguments to be passed to and from other methods.}

\item{object}{An object of class "bekkFit" from function \link{bekk_fit}.}

\item{k}{Numeric value, the penalty per parameter for AIC to be used; the default k = 2 is the classical AIC.}
}
\description{
Generic 'bekkFit' methods. More details on 'bekkFit' are described in \link{bekk_fit}
}
\examples{
\donttest{

data(StocksBonds)

# Fitting a symmetric BEKK model
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

logLik(x1)
}
}
