% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior-params.R
\name{prior_param}
\alias{prior_param}
\title{Build a Prior List for BayesSIM Models}
\usage{
prior_param(
  indexprior,
  link,
  index_direction = NULL,
  index_dispersion = NULL,
  index_nu_r1 = NULL,
  index_nu_r2 = NULL,
  index_psi_alpha = NULL,
  index_sigma_theta = NULL,
  index_r1 = NULL,
  index_r2 = NULL,
  link_basis_df = NULL,
  link_basis_degree = NULL,
  link_basis_delta = NULL,
  link_knots_lambda_k = NULL,
  link_knots_maxknots = NULL,
  link_beta_mu = NULL,
  link_beta_cov = NULL,
  link_beta_tau = NULL,
  link_beta_Sigma0 = NULL,
  link_lengthscale_shape = NULL,
  link_lengthscale_rate = NULL,
  link_amp_a = NULL,
  link_amp_b = NULL,
  link_kappa_min = NULL,
  link_kappa_max = NULL,
  link_kappa_grid_width = NULL,
  link_inv_lambda_shape = NULL,
  link_inv_lambda_rate = NULL,
  sigma2_shape = NULL,
  sigma2_rate = NULL
)
}
\arguments{
\item{indexprior}{Character scalar indicating the prior for the index.
Typically one of \code{"fisher"}, \code{"sphere"}, \code{"polar"}, or \code{"spike"}.
The valid options mirror those used in the corresponding model functions.}

\item{link}{Character scalar indicating the link function family.
Typically \code{"bspline"} for B-spline link functions or \code{"gp"} for Gaussian
process link functions. The valid options mirror those used in the
corresponding model functions.}

\item{index_direction, index_dispersion, index_nu_r1, index_nu_r2, index_psi_alpha, index_sigma_theta, index_r1, index_r2}{Optional overrides for hyper-parameters related to the index prior.}

\item{link_basis_df, link_basis_degree, link_basis_delta}{Optional overrides for the B-spline basis hyper-parameters, such as the effective degrees of freedom,
spline degree, and penalty parameter.}

\item{link_knots_lambda_k, link_knots_maxknots}{Optional overrides for the B-spline knot-selection hyper-parameters in, used for models with adaptive knot placement.}

\item{link_beta_mu, link_beta_cov, link_beta_tau, link_beta_Sigma0}{Optional overrides for the prior on spline coefficients. The detailed interpretation of these
hyper-parameters depends on the specific model and is described in the
documentation of each model-fitting function.}

\item{link_lengthscale_shape, link_lengthscale_rate}{Optional overrides for the hyper-parameters of the GP length-scale prior.}

\item{link_amp_a, link_amp_b}{Optional overrides for the hyper-parameters of the GP amplitude prior.}

\item{link_kappa_min, link_kappa_max, link_kappa_grid_width}{Optional overrides for the hyper-parameters in used in models with polar index and GP-type link,
to control the grid or support for the concentration parameter \eqn{\kappa} in \code{gpPolar}.}

\item{link_inv_lambda_shape, link_inv_lambda_rate}{Optional overrides for spike-and-slab–type GP link priors.}

\item{sigma2_shape, sigma2_rate}{Optional overrides for the inverse-gamma prior on the observation
variance \eqn{\sigma^2}.}
}
\value{
A nested list with top-level elements \code{index}, \code{link}, and
\code{sigma2}, suitable for passing to the \code{prior} argument of the
various BayesSIM model fitting functions.
}
\description{
\code{prior_param} is a convenience helper that constructs a nested prior list
for a given combination of index prior and link function.
It starts from the model-specific default prior, and then overwrites only those components for
which the user supplies non-\code{NULL} arguments.

This allows users to modify selected hyper-parameters without having to know
or manually reconstruct the full nested prior list structure.
}
\details{
\code{prior_param(indexprior, link)} can be used to obtain the default prior
list for the requested combination of index prior and link function.
For any argument that is not \code{NULL}, the corresponding field in the nested prior list is overwritten.

The detailed meaning and recommended choices for each hyper-parameter depend
on the specific model, prior of index vector and link function.
For those details, please refer to the documentation of the corresponding
model-fitting functions.
}
\examples{
## Default prior for Fisher index + B-spline link:
p0 <- prior_param("fisher", "bspline")

## Modify only a few hyper-parameters:
p1 <- prior_param(
  indexprior          = "fisher",
  link                = "bspline",
  sigma2_shape        = 0.5,
  link_basis_df       = 30,
  index_direction     = c(1, 0, 0)
)
}
\seealso{
\code{\link[=bsFisher]{bsFisher()}}, \code{\link[=bsSphere]{bsSphere()}}, \code{\link[=bsPolar]{bsPolar()}}, \code{\link[=bsSpike]{bsSpike()}},
\code{\link[=gpFisher]{gpFisher()}}, \code{\link[=gpSphere]{gpSphere()}}, \code{\link[=gpPolar]{gpPolar()}}, \code{\link[=gpPolarHigh]{gpPolarHigh()}}, \code{\link[=gpSpike]{gpSpike()}}
}
