% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq.R
\name{EQRN_excess_probability_seq}
\alias{EQRN_excess_probability_seq}
\title{Tail excess probability prediction using an EQRN_seq object}
\usage{
EQRN_excess_probability_seq(
  val,
  fit_eqrn,
  X,
  Y,
  intermediate_quantiles,
  interm_lvl = fit_eqrn$interm_lvl,
  crop_predictions = FALSE,
  body_proba = "default",
  proba_type = c("excess", "cdf"),
  seq_len = fit_eqrn$seq_len,
  device = default_device()
)
}
\arguments{
\item{val}{Quantile value(s) used to estimate the conditional excess probability or cdf.}

\item{fit_eqrn}{Fitted \code{"EQRN_seq"} object.}

\item{X}{Matrix of covariates to predict the response's conditional excess probabilities.}

\item{Y}{Response variable vector corresponding to the rows of \code{X}.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{crop_predictions}{Whether to crop out the fist \code{seq_len} observations (which are \code{NA}) from the returned vector}

\item{body_proba}{Value to use when the predicted conditional probability is below \code{interm_lvl}
(in which case it cannot be precisely assessed by the model).
If \code{"default"} is given (the default), \code{paste0(">",1-interm_lvl)} is used if \code{proba_type=="excess"},
and \code{paste0("<",interm_lvl)} is used if \code{proba_type=="cdf"}.}

\item{proba_type}{Whether to return the \code{"excess"} probability over \code{val} (default) or the \code{"cdf"} at \code{val}.}

\item{seq_len}{Data sequence length (i.e. number of past observations) used to predict each response quantile.
By default, the training \code{fit_eqrn$seq_len} is used.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Vector of probabilities (and possibly a few \code{body_proba} values if \code{val} is not large enough) of length \code{nrow(X)}
(or \code{nrow(X)-seq_len} if \code{crop_predictions}).
}
\description{
Tail excess probability prediction using an EQRN_seq object
}
