\name{quantF}
\alias{quantF}
\title{Predictive quantile of peaks-over-threshold models}
\usage{
quantF(x, y, p)
}
\arguments{
\item{x}{vector of grid of points at which the predictive density is evaluated}

\item{y}{vector containing estimates of the predictive density, e.g., the posterior predictive density}

\item{p}{double indicating the probability level corresponding to the quantile}
}
\value{
double containing the value of the quantile
}
\description{
Given an estimated predictive density evaluated at a grid of points, return the smallest value of the quantile of the predictive distribution function
below which a specific probability level corresponds. Namely, \eqn{Q(p) = \inf\{ x \in \mathbb{R}: p \leq F(x)\}}, where \eqn{F(x)} is the
predictive distribution function of a peak-over-threshold object.
WARNING: this function will not be exported in a future version of the package.
}
\examples{
\dontrun{
# generate data
set.seed(1234)
n <- 500
samp <- evd::rfrechet(n,0,1:n,4)
# set effective sample size and threshold
k <- 50
threshold <- sort(samp,decreasing = TRUE)[k+1]
# preliminary mle estimates of scale and shape parameters
mlest <- evd::fpot(samp, threshold, control=list(maxit = 500))
# empirical bayes procedure
proc <- estPOT(
  samp,
  k = k,
  pn = c(0.01, 0.005),
  type = "continuous",
  method = "bayesian",
  prior = "empirical",
  start = as.list(mlest$estimate),
  sig0 = 0.1)
# conditional predictive density estimation
yg <- seq(0, 50, by = 2)
nyg <- length(yg)
# estimation of scedasis function
# setting
M <- 1e3
C <- 5
alpha <- 0.05
bw <- .5
nsim <- 5000
burn <- 1000
# create covariate
# in sample obs
n_in = n
# number of years ahead
nY = 1
n_out = 365 * nY
# total obs
n_tot = n_in + n_out
# total covariate (in+out sample period)
x <- seq(0, 1, length = n_tot)
# in sample grid dimension for covariate
ng_in <- 150
xg <- seq(0, x[n_in], length = ng_in)
# in+out of sample grid
xg <- c(xg, seq(x[n_in + 1], x[(n_tot)], length = ng_in))
# in+out sample grid dimension
nxg <- length(xg)
xg <- array(xg, c(nxg, 1))
# in sample observations
samp_in <- samp[1:n_in]
ssamp_in <- sort(samp_in, decreasing = TRUE, index = TRUE)
x_in <- x[1:n_in] # in sample covariate
xs <- x_in[ssamp_in$ix[1:k]] # in sample concomitant covariate
# estimate scedasis function over the in and out of sample period
res_stat <- apply(
  xg,
  1,
  cpost_stat,
  N = nsim - burn,
  x = x_in,
  xs = xs,
  bw = bw,
  k = k,
  C = C
)
# conditional predictive posterior density
yg <- seq(500, 5000, by = 100)
nyg = length(yg)
# intermediate threshold
predDens_intx <- predDensx(
  x = yg,
  postsamp = proc$post_sample,
  scedasis = res_stat,
  threshold = proc$t,
  "continuous",
  extrapolation = FALSE)
# extreme threshold
predDens_extx <- predDensx(
  x = yg,
  postsamp = proc$post_sample,
  scedasis = res_stat,
  threshold = proc$t,
  "continuous",
  extrapolation = TRUE,
  p = 0.001,
  k = k,
  n = n)
  # predictive conditional quantiles
predQuant_intxL <- predQuant_intxU <- predQuant_extxL <- predQuant_extxU <- numeric()
for (i in 1:nxg){
  predQuant_intxU[i] <- apply(
    array(predDens_intx$preddens[,i], c(1, nyg)),
    1,
    quantF,
    x = yg,
    p = c(0.975)
  )
  predQuant_intxL[i] <- apply(
    array(predDens_intx$preddens[,i], c(1, nyg)),
    1,
    quantF,
    x = yg,
    p = c(0.025)
  )
  predQuant_extxU[i] <- apply(
    array(predDens_extx$preddens[,i], c(1, nyg)),
    1,
    quantF,
    x = yg,
    p = c(0.975)
  )
  predQuant_extxL[i] <- apply(
    array(predDens_extx$preddens[,i], c(1, nyg)),
    1,
    quantF,
    x = yg,
    p = c(0.025)
  )
}
}
}
\keyword{internal}
