% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_gace}
\alias{plot_gace}
\title{Plot GACE Forecast}
\usage{
plot_gace(fc)
}
\arguments{
\item{fc}{A data frame returned by gace_forecast(), containing:
\itemize{
\item \code{period} – numeric or convertible index,
\item \code{value}  – observed or forecast values,
\item \code{type}   – "historical" or "forecast".
}}
}
\value{
A ggplot2 object.
}
\description{
Produces a plot of historical and forecast values returned by
gace_forecast(). Includes stability handling for missing values,
non-numeric periods, and clean ggplot2 output.
}
\examples{
\donttest{
  set.seed(1)
  y <- ts(rnorm(48, mean = 100, sd = 10), frequency = 12)
  fc <- gace_forecast(y, periods = 6, freq = "month")
  plot_gace(fc)
}

}
