% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrob_prConvert2Coords.R
\name{prConvert2Coords}
\alias{prConvert2Coords}
\title{Converts an object to coordinates}
\usage{
prConvert2Coords(obj)
}
\arguments{
\item{obj}{A single or a \code{list} of \code{[}boxGrob\verb{], }\code{\link{boxPropGrob}}, \code{[}coords\verb{] output, }\code{\link[grid:unit]{unit}}
or a numeric value that can be converted to an \code{npc} \code{[}unit\verb{][grid::unit]. If a }list\verb{is provided the function recursively converts each element and returns bounding coordinates that encompass all elements; the returned units are in}npc` so the coordinates resize with the viewport.}
}
\value{
A \code{list} with all the points that \code{\link{coords}} returns. For list inputs the function returns merged
bounding coordinates (class \code{box_coords}) with units in \code{npc}.
}
\description{
Sometimes we have an object that can be either a box,
a coordinate, a unit or a numerical value and all we
want is a \code{list} of coordinates that we can use for
calculating distance, alignment and other things.
}
\details{
When given a list, \code{prConvert2Coords} computes the min/max of edges (or uses center +/- half sizes
if edges are missing) to create a merged bounding box. Any additional coordinate names present on elements
are merged heuristically (e.g., \verb{left*} -> min, \verb{right*} -> max, else averaged).
}
\examples{
box1 <- boxGrob("A", x = .2, y = .8)
box2 <- boxGrob("B", x = .6, y = .4)
Gmisc:::prConvert2Coords(list(box1, box2))
}
