% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_match_search.R
\name{computeBinaryMatchStructure}
\alias{computeBinaryMatchStructure}
\title{Compute Binary Matching Strcuture}
\usage{
computeBinaryMatchStructure(
  X,
  mahal_match = FALSE,
  compute_dist_matrix = NULL,
  D = NULL,
  symmetry_tol = 1e-12,
  use_safe_inverse = FALSE
)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{mahal_match}{Match using Mahalanobis distance. Default is \code{FALSE}.}

\item{compute_dist_matrix}{The function that computes the distance matrix between every two observations in \code{X}, 
its only argument. The default is \code{NULL} signifying euclidean squared distance optimized in C++.}

\item{D}{A distance matrix precomputed. The default is \code{NULL} indicating the distance matrix should be computed.}

\item{symmetry_tol}{Tolerance for symmetry check on \code{D}. Default is \code{1e-12}.}

\item{use_safe_inverse}{Should a regularized inverse be used for the Mahalanobis objective?
Default is \code{FALSE}.}
}
\value{
An object of type \code{binary_experimental_design} which can be further operated upon.
}
\description{
This method creates an object of type binary_match_structure and will compute pairs. You can then
use the functions \code{initBinaryMatchExperimentalDesignSearchObject} and \code{resultsBinaryMatchSearch} 
to create randomized allocation vectors. For one column in X, we just sort to find the pairs trivially.
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(16), nrow = 8)
bms = computeBinaryMatchStructure(X)
bms$indicies_pairs
}
}
\author{
Adam Kapelner
}
