% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable_utils.R
\name{ald_to_Lx}
\alias{ald_to_Lx}
\title{Calculate the lifetable exposure}
\usage{
ald_to_Lx(ax, lx, dx, nx)
}
\arguments{
\item{ax}{numeric vector of ax, average time spent in the age interval by those that die in the interval}

\item{lx}{numeric vector of lx, lifetable survivorship at exact ages.}

\item{dx}{numeric vector of dx, the lifetable deaths distribution.}

\item{nx}{age interval width, assumes 1 by default}
}
\value{
numeric vector of \code{Lx} values
}
\description{
\code{Lx} is defined as the integration of \code{lx} in the interval \verb{[x,x+n)}, where \code{n} is the width of the interval. There are many approximations for this. Here we use HMD Method Protocol equation 78. You can think of \code{Lx} as lifetable exposure, or person-years lived in each age interval.
}
\references{
\insertRef{wilmoth2021methods}{LEdecomp}
}
