% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_RLum.Data.Spectrum.R
\name{merge_RLum.Data.Spectrum}
\alias{merge_RLum.Data.Spectrum}
\title{Merge function for RLum.Data.Spectrum S4 class objects}
\usage{
merge_RLum.Data.Spectrum(
  object,
  merge.method = "mean",
  method.info = NULL,
  max.temp.diff = 0.1
)
}
\arguments{
\item{object}{\link{list} of \linkS4class{RLum.Data.Spectrum} (\strong{required}):
list of objects to be merged.}

\item{merge.method}{\link{character} (\strong{required}):
method for combining of the objects, e.g. \code{'mean'} (default), \code{'median'},
\code{'sum'}, see details for
further information and allowed methods.  Note: Elements in slot info will
be taken from the first object in the list.}

\item{method.info}{\link{numeric} (\emph{optional}):
allows to specify how info elements of the input objects are combined,
e.g. \code{1} means that just the elements from the first object are kept,
\code{2} keeps only the info elements from the 2 object etc.
If set to \code{NULL}, all elements are combined.}

\item{max.temp.diff}{\link{numeric} (\emph{with default}):
maximum difference in the time/temperature values between the spectra to
be merged: when differences exceed this threshold value, the merging
occurs but a warning is raised.}
}
\value{
Returns an \linkS4class{RLum.Data.Spectrum} object.
}
\description{
This function allows to merge \linkS4class{RLum.Data.Spectrum} objects in
different ways without modifying the original objects.
}
\details{
\strong{Supported merge operations are:}

\code{"mean"} (default)

The mean over the cell values is calculated using the function
\link{rowMeans}.

\code{"median"}

The median over the cell values is calculated using the function
\link[matrixStats:rowMedians]{matrixStats::rowMedians}.

\code{"sum"}

All cell values will be summed up using the function \link{rowSums}.

\code{"sd"}

The standard deviation over the cell values is calculated using the function
\link[matrixStats:rowSds]{matrixStats::rowSds}.

\code{"var"}

The variance over the cell values is calculated using the function
\link[matrixStats:rowVars]{matrixStats::rowVars}.

\code{"min"}

The min values from the cell values is chosen using the function
\link[matrixStats:rowRanges]{matrixStats::rowMins}.

\code{"max"}

The max values from the cell values is chosen using the function
\link[matrixStats:rowRanges]{matrixStats::rowMins}.

\code{"append"} (only for \linkS4class{RLum.Data.Curve})

Appends cell values of all curves to one combined data curve. The channel width
is automatically re-calculated, but requires a constant channel width of the
original data.

\code{"-"}

The cell sums of the last objects are subtracted from the first object.

\code{"*"}

The cell sums of the last objects are multiplied with the first object.

\code{"/"}

Values of the first object are divided by cell sums of the last objects.
}
\note{
The information from the slot \code{recordType} is taken from the first
object in the input list. The slot
'curveType' is filled with the name \code{merged}.
}
\section{S3-generic support}{


This function is fully operational via S3-generics:
\code{+}, \code{-}, \code{/}, \code{*}, \code{merge}
}

\section{Function version}{
 0.1.2
}

\examples{

## load example data
data(ExampleData.XSYG, envir = environment())

## plot single curve
plot_RLum(TL.Spectrum)

## sum two copies of the same curve
merged <- merge_RLum.Data.Spectrum(list(TL.Spectrum, TL.Spectrum),
                                   merge.method = "sum")
plot_RLum(merged)

}
\seealso{
\link{merge_RLum}, \linkS4class{RLum.Data.Spectrum}
}
\author{
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Colombo, M., Kreutzer, S., 2025. merge_RLum.Data.Spectrum(): Merge function for RLum.Data.Spectrum S4 class objects. Function version 0.1.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{internal}
\keyword{utilities}
