% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.emee.R
\name{summary.emee_fit}
\alias{summary.emee_fit}
\title{Summarize Causal Excursion Effect Fits for MRT with Binary Outcomes}
\usage{
\method{summary}{emee_fit}(
  object,
  lincomb = NULL,
  conf_level = 0.95,
  show_control_fit = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class "emee_fit".}

\item{lincomb}{A vector of length p (p is the number of moderators including
intercept) or a matrix with p columns. When not set to `NULL`,
the summary will include the specified linear combinations of the causal excursion
effect coefficients and the corresponding confidence interval, standard error,
and p-value.}

\item{conf_level}{A numeric value indicating the confidence level for
confidence intervals. Default to 0.95.}

\item{show_control_fit}{A logical value of whether the fitted coefficients
for the control variables will be printed in the summary. Default to FALSE.
(Interpreting the fitted coefficients for control variables is not recommended.)}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
the original function call and the estimated causal excursion effect
coefficients, confidence interval with conf_level, standard error, t-statistic value,
degrees of freedom, and p-value.
}
\description{
\code{summary} method for class "emee_fit".
}
\examples{
fit <- emee(
    data = data_binary,
    id = "userid",
    outcome = "Y",
    treatment = "A",
    rand_prob = "rand_prob",
    moderator_formula = ~time_var1,
    control_formula = ~ time_var1 + time_var2,
    availability = "avail",
    numerator_prob = 0.5,
    start = NULL
)
summary(fit)
}
