% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_roles.R
\name{recipe_roles}
\alias{recipe_roles}
\alias{role_binom}
\alias{role_case}
\alias{role_pred}
\alias{role_surv}
\title{Set Recipe Roles}
\usage{
role_binom(recipe, x, size)

role_case(recipe, group, stratum, weight, replace = FALSE)

role_pred(recipe, offset, replace = FALSE)

role_surv(recipe, time, event)
}
\arguments{
\item{recipe}{existing \link[recipes]{recipe} object.}

\item{x, size}{number of counts and trials for the specification of a
\code{\link{BinomialVariate}} outcome.}

\item{group}{variable defining groupings of case observations, such as
repeated measurements, to keep together during resampling [default: none].}

\item{stratum}{variable to use in conducting stratified \link{resample}
estimation of model performance.}

\item{weight}{numeric variable of case weights for model
\link[=fit]{fitting}.}

\item{replace}{logical indicating whether to replace existing roles.}

\item{offset}{numeric variable to be added to a linear predictor, such as in
a generalized linear model, with known coefficient 1 rather than an
estimated coefficient.}

\item{time, event}{numeric follow up time and 0-1 numeric or logical event
indicator for specification of a \code{\link[survival]{Surv}} outcome.  If
the event indicator is omitted, all cases are assumed to have events.}
}
\value{
An updated recipe object.
}
\description{
Add to or replace the roles of variables in a preprocessing recipe.
}
\examples{
library(survival)
library(recipes)

df <- within(veteran, {
  y <- Surv(time, status)
  remove(time, status)
})
rec <- recipe(y ~ ., data = df) \%>\%
  role_case(stratum = y)

(res <- resample(rec, model = CoxModel))
summary(res)

}
\seealso{
\code{\link[recipes]{recipe}}
}
