# Ordinal Logistic Biplot with Gradient Descent
OrdinalLogBiplotGDRecursive <- function(X, freq = matrix(1, nrow(X), 1),  dim = 2, tolerance = 1e-04,  
                                        penalization=0.2, num_max_iters=100, RotVarimax = FALSE, 
                                        OptimMethod="CG", Initial="random", seed=0, ...) {
  # Recursive algorithm for ordinal logistic biplots 
  # Input must be a data frame with ordinal categorical variables or a matrix with integers representing ordinal variables
  # For the moment, the maximum number of categories must be the same for all the variables.
  ncats=apply(X,2, max)
  maxcat=max(ncats)
  X=as.matrix(X)
  indnames=rownames(X)
  varnames=colnames(X)
  I <- nrow(X)
  J <- ncol(X)
  # Estimation of parameters A and B
  r=dim
  
  # Matrix of category indicators P
  P=NULL
  Nombres=NULL
  for (j in 1:J){
    for (k in 1:(maxcat)){
      P=cbind(P,as.numeric(X[,j]==k))
      Nombres=cbind(Nombres,paste(varnames[j],k, sep="-"))
      }
  }

  colnames(P)=Nombres
  rownames(P)=indnames
  
  # Matrix of cummulative categories C
  C=NULL
  Nombres=NULL
  for (j in 1:J){
    for (k in 1:(maxcat-1)){
      C=cbind(C,as.numeric(X[,j]<=k))
      Nombres=cbind(Nombres,paste(varnames[j],k, sep="<="))
      }
  }
  colnames(C)=Nombres
  rownames(C)=indnames

  L=dim(C)[2]
  
  # Fitting the constants (number of categories minus one)
  cat("\n Fitting the constants ")
  d=matrix(0,nrow=L, ncol=1)
  d <- optim(par=d, fn=JOrdLogBiplotd, gr=grOrdLogBiplotd, method=OptimMethod, C=C)$par
  constants=NULL
  for (j in 1:J){
    constants=rbind(constants, d[((j-1)*(maxcat-1)+1):((j+1)*(maxcat-1)-(maxcat-1))])
  }
  rownames(constants)=varnames
  colnames(constants)=paste("Cat", 1:(maxcat-1), sep="-")
## Fitting the rest of the dimensions recursively
  cat("\n Fitting the parameters ")
  A=NULL
  B=NULL
  set.seed(seed)
  for (k in 1:r){
    cat(paste("\n Fitting dimension ", k))
    parA=rnorm(I)
    parA=(parA-mean(parA))/sd(parA)
    parB=rnorm(J)
    A=cbind(A,parA)
    B=cbind(B,parB)
    Cost=JOrdLogBiplot(C, d, A, B , lambda=penalization)
    err=1
    iter=0
    while( (err > tolerance) & (iter<num_max_iters)){
      iter=iter+1
      Jold=Cost
      #Update B
      resbipB <- optim(parB, fn=JOrdLogBiplotB, gr=grOrdLogBiplotB, method=OptimMethod, C=C, d=d, A=A, B=B,lambda=penalization)
      parB=resbipB$par
      B[,k]=parB
      #Update A
      resbipA <- optim(parA, fn=JOrdLogBiplotA, gr=grOrdLogBiplotA, method=OptimMethod, C=C, d=d, A=A, B=B, lambda=penalization)
      parA=resbipA$par
      parA=(parA-mean(parA))/sd(parA)
      A[,k]=parA
      Cost=JOrdLogBiplot(C, d, A, B , lambda=penalization)
      err=abs(Jold-Cost)/Cost
      cat("\n", round(iter), round(Cost, 3), round(err,6))
    }
  }
  
  cat("\n Calculating the associated factor model")

  if (RotVarimax) {
    BB = varimax(B, normalize = FALSE)
    A = A %*% BB$rotmat
    B = B %*% BB$rotmat
  }
  
  #B=-1*B
  
  #Associated Factor Model
  dd = sqrt(rowSums(B^2) + 1)
  loadings = solve(diag(dd)) %*% B
  thresholds = solve(diag(dd)) %*% constants
  r2 = rowSums(loadings^2)
  
  
  rownames(thresholds)=varnames
  colnames(thresholds)=paste("Cat", 1:(maxcat-1), sep="-")
  
  cat("\n Building the solution \n")
  rownames(A)=indnames
  colnames(A)=paste("dim",1:dim)
  rownames(B)=varnames
  colnames(B)=paste("dim",1:dim)
  model=list()
  model$Data=X
  model$Dimension=dim
  model$Penalization=penalization
  model$Tolerance=tolerance
  model$OptimMethod=OptimMethod
  model$Biplot="Ordinal Logistic (Recursive Gradient Descent)"
  model$Type= "Ordinal Logistic (Recursive Gradient Descent)"
  
  model$InitialConfiguration=Initial
  model$Penalization=penalization
  model$NumberIterations=iter
  
  model$RowCoordinates=A
  model$ColCoordinates=B
  model$Thresholds=thresholds
  
  model$RowContributions=matrix(100/dim,I,dim)
  rownames(model$RowContributions)=indnames
  colnames(model$RowContributions)=paste("Dim_",1:dim,sep="")
  
  model$loadings = loadings
  rownames(model$loadings)=varnames
  colnames(model$loadings)=paste("Dim", 1:dim)
  model$Communalities = matrix(r2, J,1)
  rownames(model$Communalities)=varnames
  colnames(model$Communalities)="Communalities"
  model$ColContributions = loadings^2 
  rownames(model$ColContributions)=varnames
 
  par=ExpectedOrdinalBiplot(X, C, d, A, B)
  model$Expected=par$Expected
  rownames(par$coefficients) = varnames
  colnames(par$coefficients) = paste("Dim_",1:dim,sep="")
  
  par$thresholds=thresholds
  rownames(par$thresholds) = varnames
  colnames(par$thresholds) = paste("C_",1:(maxcat-1),sep="")
  
  
  model$ColumnParameters = par
  model$Fit=par$fit
  model$Ncats=par$Ncats
  
  
  class(model) = "Ordinal.Logistic.Biplot"
  
  model$ClusterType="us"
  model$Clusters = as.factor(matrix(1,I, 1))
  model$ClusterColors="blue"
  model$ClusterNames="ClusterTotal"
  class(model) = "Ordinal.Logistic.Biplot"
  return(model)
}


