% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupSizes.R
\name{groupSizes}
\alias{groupSizes}
\title{Group Sizes}
\usage{
groupSizes(ml, ...)
}
\arguments{
\item{ml}{Either a Rdistance 'model frame' or an Rdistance 
'fitted object'.  Both are of class "dfunc". 
Rdistance 'model frames' are lists containing components 
necessary to estimate a distance function, but no estimates. 
Rdistance 'model frames' are typically
produced by calls to \code{\link{parseModel}}. 
Rdistance 'fitted objects'
are typically produced by calls to \code{\link{dfuncEstim}}.
'Fitted objects' are 'model frames'
with additional components such as the parameters estimates, 
log likelihood value, convergence information, and the variance-
covariance matrix of the parameters.}

\item{...}{Ignored}
}
\value{
A vector containing group sizes contained
in the Rdistance model frame or fitted object.
}
\description{
Extract the group size information from 
an Rdistance model frame.
}
\examples{

data("sparrowDf")
sparrowModel <- parseModel( sparrowDf, dist ~ observer )
stats::model.offset(sparrowModel$mf)
groupSizes(sparrowModel)  # same, but future-proof

sparrowModel <- parseModel( sparrowDf
                 , dist ~ observer + groupsize(groupsize) )
groupSizes(sparrowModel)  

}
