% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_FMM_SemiSupervised_Complete_Initial.R
\name{EM_FMM_SemiSupervised_Complete_Initial}
\alias{EM_FMM_SemiSupervised_Complete_Initial}
\title{Complete-Data Warm-Up Initialization for Semi-Supervised FMM
with a Mixed-Missingness Mechanism}
\usage{
EM_FMM_SemiSupervised_Complete_Initial(
  data,
  g = 2,
  ncov = 1,
  alpha_init = 0.01,
  warm_up_iter = 200,
  tol = 1e-06
)
}
\arguments{
\item{data}{A data frame containing:
\itemize{
\item The first \code{p} columns: numeric variables used in the FMM.
\item A column \code{missing}: indicator (0 = labeled, 1 = unlabeled/missing).
\item A column \code{z}: class labels for labeled rows (\code{1:g});
\code{NA} for unlabeled.
}}

\item{g}{Integer, number of mixture components (default \code{2}).}

\item{ncov}{Integer, covariance structure:
\code{1} = shared (equal), \code{2} = class-specific (unequal).}

\item{alpha_init}{Numeric in (0,1), initial MCAR proportion (default \code{0.01}).}

\item{warm_up_iter}{Integer, number of warm-up EM iterations (default \code{200}).}

\item{tol}{Convergence tolerance on \code{alpha} (default \code{1e-6}).}
}
\value{
A list with initial values for \code{\link{EM_FMM_SemiSupervised}}:
\itemize{
\item \code{pi}   - mixture weights.
\item \code{mu}   - list of component mean vectors.
\item \code{Sigma} - covariance matrix/matrices.
\item \code{alpha} - MCAR proportion.
\item \code{xi}    - logistic regression coefficients for MAR mechanism.
}
}
\description{
Uses both labeled and unlabeled subsets of the data to obtain quick initial
estimates for mixture parameters and missingness mechanism parameters
(\code{alpha}, \code{xi}) via a warm-up EM procedure.
}
\details{
\itemize{
\item This function first calls \code{\link{initialestimate}} to get initial
\eqn{\pi}, \eqn{\mu}, \eqn{\Sigma}.
\item Then it calls \code{\link{EM_FMM_SemiSupervised_Initial}} with these
values for a short warm-up run.
\item Covariance structure (\code{equal} vs. \code{unequal}) is determined
by \code{ncov}.
}
}
