% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boundary.R
\name{boundary}
\alias{boundary}
\title{Compute the boundary operator for a simplicial complex}
\usage{
boundary(simplices, bound_dim)
}
\arguments{
\item{simplices}{A list of simplices (each a numeric vector).}

\item{bound_dim}{The dimension k of the boundary operator \eqn{\partial_{k}}.}
}
\value{
A sparse matrix representing \eqn{\partial_{k}}.
}
\description{
Compute the boundary operator for a simplicial complex
}
\details{
\deqn{\partial_k \sigma = \sum_i (-1)^i [v_0 v_1 \ldots \hat{v}_i \ldots v_k]}
}
\examples{
simplices <- list(c(1, 2), c(3, 4), c(2, 1, 3), c(4, 2))
boundary(simplices, 0)
}
