% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDESCRIPTIONandDocs.R
\name{createDESCRIPTIONandDocs}
\alias{createDESCRIPTIONandDocs}
\title{Convert standard module code into an R package}
\usage{
createDESCRIPTIONandDocs(
  module = NULL,
  path = getOption("spades.modulePath"),
  importAll = TRUE,
  buildDocuments = TRUE,
  verbose = getOption("Require.verbose")
)
}
\arguments{
\item{module}{Character string of module name, without path}

\item{path}{Character string of \code{modulePath}. Defaults to  \code{getOption("spades.modulePath")}.}

\item{importAll}{A logical. If \code{TRUE}, then every package named in \code{reqdPkgs} will
have an \verb{@importFrom <pkgName>}, meaning \strong{every} function from every package will
be imported. If \code{FALSE}, then only functions explicitly imported using
\verb{@importFrom <pkgName> <functionName>} will be imported.}

\item{buildDocuments}{A logical. If \code{TRUE}, the default, then the documentation
will be built, if any exists, using \code{roxygen2::roxygenise}.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\value{
Invoked for its side effects. There will be a new or modified
\code{DESCRIPTION} file in the root directory of the module. Any functions that
were in the main module script (i.e., the .R file whose filename is the name of
the module and is in the root directory of the module) will be moved to individual
\code{.R} files in the \code{R} folder. Any function with a dot prefix will have the
dot removed in its respective filename, but the function name is unaffected.

Currently, \code{SpaDES.core} does not install the package under any circumstances.
It will load it via \code{pkgdown::load_all}, and optionally (\code{option("spades.moduleDocument" = TRUE)})
build documentation via \code{roxygen2::roxygenise} within the \code{simInit} call.
This means that any modifications to source code
will be read in during the \code{simInit} call, as is the practice when a module
is not a package.

invoked for the side effect of creating DESCRIPTION file, a \code{.Rbuildingore}
file and possibly building documentation from roxygen2 tags.
}
\description{
\emph{EXPERIMENTAL -- USE WITH CAUTION}. This function will create a \code{DESCRIPTION}
file if one does not exist, based on the module metadata. If one exists, it will
update it with any additional information: \strong{it will not remove packages that are
removed from the metadata}. It will create, if one does not
exist, or update a \code{.Rbuildignore} file. If \code{importAll = TRUE} It will create a file named \code{R/imports.R},
which will import all functions.  This function will make no changes to
any existing source file of a SpaDES.module. If \code{buildDocumentation = TRUE},
it will build documentation \code{.Rd} files from \code{roxygen2} tags.
}
\details{
This function does not install anything (e.g., \code{devtools::install}). After
running this function, \code{simInit} will automatically detect that this is now
a package and will load the functions (via \code{pkgload::load_all}) from the source files.
This will have the effect that it emulates the "non-package" behaviour of a
SpaDES module exactly. After running this function, current tests show no
impact on module behaviour, other than event-level and module-level Caching will show
changes and will be rerun. Function-level Caching appears unaffected.
In other words, this should cause no changes to running the module code via
\code{simInit} and \code{spades}.

This function will create
and fill a minimal \code{DESCRIPTION} file. This will leave the \code{defineModule}
function call as the only code in the main module file. This \code{defineModule}
and a \code{doEvent.xxx} are the only 2 elements that are required for an R
package to be considered a SpaDES module. With these changes, the module should
still function normally, but will be able to act like an
R package, e.g., for writing function documentation with \code{roxygen2},
using the \code{testthat} infrastructure, etc.

This function is intended to be run once for a module that was created using
the "standard" SpaDES module structure (e.g., from a \code{newModule} call). There
is currently no way to "revert" the changes from R (though it can be done using
version control utilities if all files are under version control, e.g., GitHub).
Currently \code{SpaDES.core} identifies a module as being a package if it has
a \code{DESCRIPTION} file, or if it has been installed to the \code{.libPaths()}
e.g., via \code{devtools::install} or the like. So one can simply remove the
package from \code{.libPaths} and delete the \code{DESCRIPTION} file and
\code{SpaDES.core} will treat it as a normal module.
}
\section{Reverting}{

Currently, this is not a reversible process. We recommend trying one module at
a time, running your code. If all seems to work, then great. Commit the changes.
If things don't seem to work, then revert the changes and continue on as before.
Ideally, file a bug report on the \code{SpaDES.core} GitHub.com pages.

Currently
}

\section{Exported functions}{


The only function that will be exported by default is the \code{doEvent.xxx},
where \code{xxx} is the module name. If any other module is to be exported, it must
be explicitly exported with e.g., \verb{@export}, and then building the \code{NAMESPACE}
file, e.g., via \code{devtools::document(moduleRootPath)}. NOTE: as long as all
the functions are being used inside each other, and they all can be traced back
to a call in \code{doEvent.xxx}, then there is no need to export anything else.
}

\section{DESCRIPTION}{


The \code{DESCRIPTION} file that is created (destroying any existing \code{DESCRIPTION}
file) with this function will have
several elements that a user may wish to change. Notably, all packages that were
in \code{reqdPkgs} in the SpaDES module metadata will be in the \code{Imports}
section of the \code{DESCRIPTION}. To accommodate the need to see these functions,
a new R script, \code{imports.R} will be created with \verb{@import} for each
package in \code{reqdPkgs} of the module metadata. However, if a module already has used
\verb{@importFrom} for importing a function from a package, then the generic
\verb{@import} will be omitted for that (those) package(s).
So, a user should likely follow standard R package
best practices and use \verb{@importFrom} to identify the specific functions that
are required within external packages, thereby limiting function name collisions
(and the warnings that come with them).

Other elements of a standard \code{DESCRIPTION} file that will be missing or possibly
inappropriately short are \code{Title}, \code{Description}, \code{URL},
\code{BugReports}.
}

\section{Installing as a package}{


There is no need to "install" the source code as a package because \code{simInit}
will load it on the fly. But, there may be reasons to install it, e.g., to have
access to individual functions, help manual, running tests etc. To do this,
simply use the \code{devtools::install(pathToModuleRoot)}. Even if it is installed,
\code{simInit} will nevertheless run \code{pkgload::load_all} to ensure the
\code{spades} call will be using the current source code.
}

\examples{
if (requireNamespace("ggplot2") && requireNamespace("pkgload") ) {
  tmpdir <- tempdir2()
  newModule("test", tmpdir, open = FALSE)
  createDESCRIPTIONandDocs("test", path = tmpdir)
}
}
