% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-simInit.R
\name{simInitAndSpades2}
\alias{simInitAndSpades2}
\alias{simInitAndSpades}
\title{\code{simInitAndSpades2} is a convenience wrapper for \code{do.call(simInitAndSpades, listOfArgs)},
i.e., a user can pass a list of all the arguments.}
\usage{
simInitAndSpades2(l)

simInitAndSpades(
  times,
  params,
  modules,
  objects,
  paths,
  inputs,
  outputs,
  loadOrder,
  notOlderThan,
  debug = getOption("spades.debug"),
  progress,
  cache,
  .plots,
  .plotInitialTime,
  .saveInitialTime,
  events,
  ...
)
}
\arguments{
\item{l}{A list of arguments to passed to \code{simInitAndSpades}.}

\item{times}{A named list of numeric simulation start and end times
(e.g., \code{times = list(start = 0.0, end = 10.0, timeunit = "year")}),
with the final optional element, \code{timeunit}, overriding the default
time unit used in the simulation which is the "smallest time unit" across all
modules. See examples.}

\item{params}{A list of lists of the form \code{list(moduleName=list(param1=value, param2=value))}.
See details.}

\item{modules}{A named list of character strings specifying the names of modules to be loaded
for the simulation.
Note: the module name should correspond to the R source file from which the module is loaded.
Example: a module named "caribou" will be sourced form the file \file{caribou.R},
located at the specified \code{modulePath(simList)} (see below).}

\item{objects}{(optional) A vector of object names (naming objects
that are in the calling environment of
the \code{simInit}, which is often the
\code{.GlobalEnv} unless used programmatically.
NOTE: this mechanism will
fail if object name is in a package dependency), or
a named list of data objects to be
passed into the \code{simList} (more reliable).
These objects will be accessible
from the \code{simList} as a normal list, e.g,. \code{mySim$obj}.}

\item{paths}{An optional named list with up to 4 named elements,
\code{modulePath}, \code{inputPath}, \code{outputPath}, and \code{cachePath}.
See details. NOTE: Experimental feature now allows for multiple \code{modulePath}s
to be specified in a character vector. The modules will be searched for sequentially
in the first \code{modulePath}, then if it doesn't find it, in the second etc.}

\item{inputs}{A \code{data.frame}. Can specify from 1 to 6
columns with following column names: \code{objectName} (character, required),
\code{file} (character), \code{fun} (character), \code{package} (character),
\code{interval} (numeric), \code{loadTime} (numeric).
See \code{\link[=inputs]{inputs()}} and vignette("ii-modules") section about inputs.}

\item{outputs}{A \code{data.frame}. Can specify from 1 to 5
columns with following column names: \code{objectName} (character, required),
\code{file} (character), \code{fun} (character), \code{package} (character),
\code{saveTime} (numeric) and \code{eventPriority} (numeric). If
\code{eventPriority} is not set, it defaults to \code{.last()}. If \code{eventPriority}
is set to a low value, e.g., 0, 1, 2 and \code{saveTime} is \code{start(sim)},
it should give "initial conditions".

See \code{\link[=outputs]{outputs()}} and
\code{vignette("ii-modules")} section about outputs.}

\item{loadOrder}{An optional character vector of module names specifying the order in
which to load the modules. If not specified, the module
load order will be determined automatically.}

\item{notOlderThan}{A time, as in from \code{Sys.time()}. This is passed into
the \code{Cache} function that wraps \code{.inputObjects}.
If the module uses the \code{.useCache} parameter and it is
set to \code{TRUE} or \code{".inputObjects"},
then the \code{.inputObjects} will be cached.
Setting \code{notOlderThan = Sys.time()} will cause the
cached versions of \code{.inputObjects} to be refreshed,
i.e., rerun.}

\item{debug}{Optional tools for invoking debugging. Supplying a \code{list}
will invoke the more powerful \code{logging} package. See details.
Default is to use the value in \code{getOption("spades.debug")}.}

\item{progress}{Logical (\code{TRUE} or \code{FALSE} show a graphical progress bar),
character (\code{"graphical"}, \code{"text"}) or numeric indicating
the number of update intervals to show in a graphical progress bar.}

\item{cache}{Logical. If \code{TRUE}, then the \code{spades} call will be cached.
This means that if the call is made again with the same \code{simList},
then \code{spades} will return the return value from the previous run
of that exact same \code{simList}. Default \code{FALSE}. See Details.
See also the vignette on caching for examples.}

\item{.plots}{Character. Sets the parameter of this name in all modules.
See \code{\link[=Plots]{Plots()}} for possible values. The parameter is intended to slowly
take over from \code{.plotInitialTime} as a mechanism to turn on or off plotting.
For backwards compatibility, if \code{.plotInitialTime} is not set in this \code{spades} call,
but this \code{.plots} is used, two things will happen: setting this without \code{"screen"}
will turn off all plotting; setting this with \code{"screen"} will trigger
plotting for any modules that use this parameter but will have no effect on
other modules. To get plotting, therefore, it may be necessary to also set
\code{.plotInitialTime = start(sim)}.}

\item{.plotInitialTime}{Numeric. Temporarily override the \code{.plotInitialTime}
parameter for all modules. See Details.}

\item{.saveInitialTime}{Numeric. Temporarily override the \code{.plotInitialTime}
parameter for all modules. See Details.}

\item{events}{A character vector or a named list of character vectors. If specified,
the simulations will only do the events indicated here. If a named list, the names
must correspond to the modules and the character vectors can be specific events within
each of the named modules. With the \code{list} form, all unspecified modules
will run \emph{all} their events, including internal spades modules, e.g., \code{save},
that get invoked with the \code{outputs} argument in  \code{simInit}. See example.}

\item{...}{Arguments passed to \code{simInit()} and \code{spades()}}
}
\value{
Same as \code{\link[=spades]{spades()}} (a \code{simList}) or
}
\description{
These functions are convenience wrappers that may allow for more efficient caching.
Passes all arguments to \code{simInit()}, then passes the created \code{simList} to \code{spades()}.
}
\seealso{
\code{\link[=simInit]{simInit()}}, \code{\link[=spades]{spades()}}
}
