% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PKNCA.R
\name{PKNCA_create_data_object}
\alias{PKNCA_create_data_object}
\title{Creates a \code{PKNCA::PKNCAdata} object.}
\usage{
PKNCA_create_data_object(adnca_data)
}
\arguments{
\item{adnca_data}{Data table containing ADNCA data.}
}
\value{
\code{PKNCAdata} object with concentration, doses, and units based on ADNCA data.
}
\description{
Creates a \code{PKNCA::PKNCAdata} object.
}
\details{
This function creates a standard PKNCAdata object from ADNCA data.
It requires the following columns in the ADNCA data:
\itemize{
\item STUDYID: Study identifier.
\item PCSPEC: Matrix.
\item ROUTE: Route of administration.
\item DOSETRT: Drug identifier.
\item USUBJID: Unique subject identifier.
\item ATPTREF: (Non- standard column). Can be any column, used for filtering the data for NCA
\item PARAM: Analyte.
\item AVAL: Analysis value.
\item AVALU: AVAL unit.
\item DOSEA: Dose amount.
\item DOSEU: Dose unit.
\item AFRLT: Actual time from first dose.
\item ARRLT: Actual time from reference dose.
\item NFRLT: Nominal time from first dose.
\item ADOSEDUR: Duration of dose.
\item RRLTU: Time unit.
}
\enumerate{
\item Creating pk concentration data using \code{format_pkncaconc_data()}.
\item Creating dosing data using \code{format_pkncadose_data()}.
\item Creating \code{PKNCAconc} object using \code{PKNCA::PKNCAconc()}.
with formula \code{AVAL ~ AFRLT | STUDYID + PCSPEC + DOSETRT + USUBJID / PARAM}.
\item Creating PKNCAdose object using \code{PKNCA::PKNCAdose()}.
with formula \code{DOSEA ~ AFRLT | STUDYID + DOSETRT + USUBJID}.
\item Creating PKNCAdata object using \code{PKNCA::PKNCAdata()}.
\item Updating units in PKNCAdata object so each analyte has its own unit.
}
}
\examples{
adnca_data <- data.frame(
STUDYID = rep("STUDY001", 6),
PCSPEC = rep("Plasma", 6),
ROUTE = rep("IV", 6),
DOSETRT = rep("DrugA", 6),
USUBJID = rep("SUBJ001", 6),
ATPTREF = rep(1, 6),
PARAM = rep("AnalyteA", 6),
AVAL = c(0, 5, 10, 7, 3, 1),
AVALU = rep("ng/mL", 6),
DOSEA = rep(100, 6),
DOSEU = rep("mg", 6),
AFRLT = c(0, 1, 2, 3, 4, 6),
ARRLT = c(0, 1, 2, 3, 4, 6),
NFRLT = c(0, 1, 2, 3, 4, 6),
ADOSEDUR = rep(0.5, 6),
RRLTU = rep("hour", 6)
)
PKNCA_create_data_object(adnca_data)

}
