% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abessgraph.R
\name{slide}
\alias{slide}
\title{Sparsity Learning for Ising moDel rEconstruction (SLIDE)}
\usage{
slide(
  x,
  weight = NULL,
  c.max = 8,
  max.support.size = NULL,
  tune.type = "cv",
  foldid = NULL,
  support.size = NULL,
  ic.scale = 1,
  graph.threshold = 0,
  newton = "approx"
)
}
\arguments{
\item{x}{Input matrix, of dimension \eqn{n \times p}; each row is an observation
vector and each column is a predictor/feature/variable.
Can be in sparse matrix format (inherit from class \code{"dgCMatrix"} in package \code{Matrix}).}

\item{weight}{Observation weights. When \code{weight = NULL},
we set \code{weight = 1} for each observation as default.}

\item{c.max}{an integer splicing size. Default is: \code{c.max = 2}.}

\item{max.support.size}{The maximum node degree in the estimated graph. If prior information is available, we recommend setting this value accordingly. Otherwise, it is internally set to \eqn{n / (\log p \log \log n)} by default.}

\item{tune.type}{The type of criterion for choosing the support size.
Available options are \code{"gic"}, \code{"ebic"}, \code{"bic"}, \code{"aic"} and \code{"cv"}.
Default is \code{"gic"}.}

\item{foldid}{an optional integer vector of values between 1, ..., nfolds identifying what fold each observation is in.
The default \code{foldid = NULL} would generate a random foldid.}

\item{support.size}{An integer vector representing the alternative support sizes.
Only used for \code{tune.path = "sequence"}. Default is \code{0:min(n, round(n/(log(log(n))log(p))))}.}

\item{ic.scale}{A non-negative value used for multiplying the penalty term
in information criterion. Default: \code{ic.scale = 1}.}

\item{graph.threshold}{A numeric value specifying the post-thresholding level for graph estimation. If prior knowledge about the minimum signal strength is available, this can be set to approximately half of that value. The default is \code{0.0}, which means no thresholding is applied.}

\item{newton}{A character specify the Newton's method for fitting generalized linear models,
it should be either \code{newton = "exact"} or \code{newton = "approx"}.
If \code{newton = "exact"}, then the exact hessian is used,
while \code{newton = "approx"} uses diagonal entry of the hessian,
and can be faster (especially when \code{family = "cox"}).}
}
\value{
a sparse interaction matrix estimation
}
\description{
Sparsity Learning for Ising moDel rEconstruction (SLIDE)
}
\examples{
p <- 16
n <- 1e3
library(abess)
train <- generate.bmn.data(n, p, type = 3, graph.seed = 1, seed = 1, beta = 0.4)
res <- slide(train[["data"]], train[["weight"]], tune.type = "gic", 
             max.support.size = rep(4, p), support.size = rep(4, p))
all((res[[1]] != 0) == (train[["theta"]] != 0))

}
