% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAMBI.R
\name{MAMBI}
\alias{MAMBI}
\title{Calculates M-AMBI, the multivariate AZTI Marine Biotic Index}
\usage{
MAMBI(
  df,
  by = NULL,
  var_H = "H",
  var_S = "S",
  var_AMBI = "AMBI",
  limits_AMBI = c(bad = 6, high = 0),
  limits_H = c(bad = 0, high = NA),
  limits_S = c(bad = 0, high = NA),
  bounds = c(PB = 0.2, MP = 0.39, GM = 0.53, HG = 0.77)
)
}
\arguments{
\item{df}{a dataframe of diversity metrics.}

\item{by}{a vector of column names found in \code{df} by which calculations
should be grouped  \emph{e.g.} \code{c("station")}. If grouping columns
are specified, then the mean values of the 3 metrics will
be calculated within each group before calculating \code{M-AMBI}
(default \code{NULL}).}

\item{var_H}{name of the column in \code{df} containing \verb{H'} Shannon species
diversity  (default \code{"H"}).}

\item{var_S}{name of the column in \code{df} containing \code{S} species richness
(default \code{"S"}).}

\item{var_AMBI}{name of the column in \code{df} containing \code{AMBI} index (default
\code{"AMBI"}).}

\item{limits_AMBI}{named vector with length 2, specifying the values of \code{AMBI}
corresponding to \emph{(i)} worst possible condition (\code{"bad"})
where \code{M-AMBI} and \code{EQR} are equal to 0.0 and \emph{(ii)} the
best possible condition (\code{"high"}) where \code{M-AMBI} and \code{EQR}
are equal to 1.0. Default \code{c("bad" = 6, "high" = 0)}.}

\item{limits_H}{named vector with length 2, specifying the values of \verb{H'}
corresponding to \emph{(i)} worst possible condition (\code{"bad"})
where \code{M-AMBI} and \code{EQR} are equal to 0.0 and \emph{(ii)} the
best possible condition (\code{"high"}) where \code{M-AMBI} and \code{EQR}
are equal to 1.0. Default \code{c("bad" = 0, "high" = NA)}.
If the \code{"bad"} value is \code{NA} then the lowest value
occurring in \code{df} and if \code{"high"} is \code{NA} then the highest
value will be used.}

\item{limits_S}{named vector with length 2, specifying the values of \code{S}
corresponding to \emph{(i)} worst possible condition (\code{"bad"})
where \code{M-AMBI} and \code{EQR} are equal to 0.0 and \emph{(ii)} the
best possible condition (\code{"high"}) where \code{M-AMBI} and \code{EQR}
are equal to 1.0. Default \code{c("bad" = 0, "high" = NA)}.
If the \code{"bad"} value is \code{NA} then the lowest value
occurring in \code{df} and if \code{"high"} is \code{NA} then the highest
value will be used.}

\item{bounds}{A named vector (\emph{length 4}) of EQR boundary values used to
normalise M-AMBI to  EQR values where the boundary between
\emph{Good} and \emph{Moderate} ecological status is 0.6. They
specify the values of M-AMBI corresponding to the boundaries
between \emph{(i)} \emph{Poor} and \emph{Bad} status (\code{"PB"}), \emph{(ii)}
\emph{Moderate} and \emph{Poor} status (\code{"MP"}), \emph{(iii)} \emph{Good} and
\emph{Moderate} status (\code{"GM"}), and \emph{(iv)} \emph{High} and \emph{Good}
status (\code{"HG"}). Default \code{c("PB" = 0.2, "MP" = 0.39, "GM" = 0.53, "HG" = 0.77)}.}
}
\value{
a dataframe containing results of the M-AMBI index calculations.
For each unique combination of \code{by} variables, the following values are
calculated:
\itemize{
\item \code{M-AMBI} : the M-AMBI index value.
\item \code{x},\code{y},\code{z} : factor scores giving coordinates in the new factor space.
}

If no \code{by} variables are specified (\code{by = NULL}), then \code{M-AMBI} will be
calculated for each row in \code{df}.

In addition, the dataframe returned contains 2 \emph{extra} rows. These contain
the limits applied for each of the metrics, corresponding to \code{"bad"}
(\code{M-AMBI} = 0.0) and \code{"high"} (\code{M-AMBI} = 1.0), as specified in the arguments
\code{limits_AMBI}, \code{limits_H}, \code{limits_S} or taken from data.
}
\description{
Calculates M-AMBI the multivariate AMBI index, based on the three separate
species diversity metrics:
\itemize{
\item AMBI index \code{AMBI}.
\item Shannon diversity index \verb{H'}
\item Species richness \code{S}.
}

\emph{"AMBI, richness and diversity, combined with the use, in a further
development, of factor analysis together with discriminant analysis, is
presented as an objective tool (named here M-AMBI) in assessing
ecological quality status"} \href{#references}{(Muxika et al., 2007)}
}
\details{
The input dataframe \code{df} should contain the three metrics \code{AMBI}, \verb{H'} and \code{S},
identified by the column names \code{var_AMBI} (default \code{"AMBI"}), \code{var_H}
(default \code{"H"}) and \code{var_S} (default \code{"S"}).

If any of these three metrics is not found in the input data, then the function
will return an error.

\code{AMBI} is calculated using the \code{\link[=AMBI]{AMBI()}} function. \verb{H'} can be calculated
using the \code{\link[=Hdash]{Hdash()}} function but it is also included as additional output from
\code{\link[=AMBI]{AMBI()}} when called with the non-default argument \code{H = TRUE}. \code{S} is an output
from both functions \code{\link[=AMBI]{AMBI()}} and \code{\link[=Hdash]{Hdash()}}.

This means that the input to \code{MAMBI()} can be generated from species count
data using only using the \code{\link[=AMBI]{AMBI()}} function.
}
\examples{

  df <- data.frame(station = c(1, 1, 1, 2, 2, 2, 3, 3),
                 replicates = c("a", "b", "c", "a", "b", "c", "a", "b"),
                 AMBI = c(1.8, 1.5, 1.125, 1.875, 2.133, 1.655, 3.5, 4.75),
                 H = c(1.055, 0.796, 0.562, 2.072, 2.333, 1.789, 1.561, 1.303),
                 S = c(3, 3, 2, 12, 12, 10, 5, 6))

 MAMBI(df, by = c("station"))


}
\references{
Muxika, I., Borja, A., Bald, J. (2007) "Using historical data, expert judgement and multivariate analysis in assessing reference conditions and benthic ecological status, according to the European Water Framework Directive", Marine Pollution Bulletin, 55, 1–6,
\doi{doi:10.1016/j.marpolbul.2006.05.025}.
}
\seealso{
\code{\link[=AMBI]{AMBI()}} which calculates the indices required as input for \code{MAMBI()}.
}
