% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-print.R
\name{get_questions}
\alias{get_questions}
\title{Get a Data Frame Summary of All Leaf Questions}
\usage{
get_questions(tree)
}
\arguments{
\item{tree}{The \code{data.tree} object to be summarised.}
}
\value{
A \code{data.frame} with one row for each leaf node and the following
columns: \code{name}, \code{question}, \code{answer}, \code{confidence} (on a 0-5 scale),
and \code{influence_index}.
}
\description{
Traverses the tree to find all leaf nodes (questions) and
compiles their key attributes into a single, tidy data frame. This is
useful for getting a complete overview of the analysis state or for
creating custom reports.
}
\examples{
# Load the example 'ethical' dataset
data(ethical)

# Build and initialise the tree object
ethical_tree <- load_tree_df(ethical)
ethical_tree <- update_tree(ethical_tree)

# Get the summary data frame of all questions
questions_df <- get_questions(ethical_tree)

# Display the first few rows
head(questions_df)
}
