% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_gibbs_sampler.R
\name{behav_gibbs_sampler}
\alias{behav_gibbs_sampler}
\title{Internal function that runs RJMCMC on a single animal ID}
\usage{
behav_gibbs_sampler(dat, ngibbs, nbins, alpha, breakpt, p)
}
\arguments{
\item{dat}{A data frame that only contains columns for the animal IDs and for
each of the discretized movement variables.}

\item{ngibbs}{numeric. The total number of iterations of the MCMC chain.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable. These must be in the same order as the columns within
\code{dat}.}

\item{alpha}{numeric. A single value used to specify the hyperparameter for
the prior distribution. A standard value for \code{alpha} is typically 1,
which corresponds with a vague prior on the Dirichlet distribution.}

\item{breakpt}{numeric. A vector of breakpoints if pre-specifying where they
may occur, otherwise \code{NULL}.}

\item{p}{An object storing information from
\code{progressr::progessor} to produce a progress bar.}
}
\value{
A list of the breakpoints, the number of breakpoints, and the log
  marginal likelihood at each MCMC iteration, as well as the time it took the
  model to finish running. This is only provided for the data of a single
  animal ID.
}
\description{
This function serves as a wrapper for \code{\link{samp_move}} by running this
sampler for each iteration of the MCMC chain. It is called by
\code{\link{segment_behavior}} to run the RJMCMC on all animal IDs
simultaneously.
}
