% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_gibbs_functions.R
\name{sample.v}
\alias{sample.v}
\title{Internal function to sample parameter for truncated stick-breaking prior}
\usage{
sample.v(z.agg, gamma1, ntsegm, ndata.types, nmaxclust)
}
\arguments{
\item{z.agg}{A list of latent cluster estimates provided by
\code{\link{sample.z}}.}

\item{gamma1}{numeric. Hyperparameter for the truncated stick-breaking prior.}

\item{ntsegm}{numeric. The total number of time segments from all animal IDs.}

\item{ndata.types}{numeric. The number of data streams being analyzed.}

\item{nmaxclust}{numeric. A single number indicating the maximum number of
clusters to test.}
}
\value{
A matrix with estimates for \emph{v} for each of the number of time
  segments and possible states.
}
\description{
This function samples the latent \emph{v} parameter within the Gibbs sampler.
Calls on the \code{CumSumInv} function written in C++. Not for calling
directly by users.
}
