% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci.R
\name{ci_prop_mid_p}
\alias{ci_prop_mid_p}
\title{Mid-P CI}
\usage{
ci_prop_mid_p(x, conf.level = 0.95, data = NULL)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{n}{Number of responses}
\item{N}{Total number}
\item{estimate}{The point estimate of the proportion}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{method}{Type of method used}
}
\description{
Calculates the exact mid-p CI for binomial proportions by inverting two one-sided binomial tests that include the mid-p tail.
This is calculated by finding the \eqn{P_L} and \eqn{P_U} that satisfies the following equations:
\deqn{\sum _{x=n_1+1}^{n} \binom {n}{x} P_{L}^{x}(1-P_{L})^{n-x} + \frac{1}{2} \binom{n}{n_1} P_{L}^{n_1}(1-P_{L})^{n-n_1} = \alpha /2}
\deqn{\sum _{x=0}^{n_1-1} \binom {n}{x} P_{U}^{x}(1-P_{U})^{n-x} + \frac{1}{2} \binom{n}{n_1} P_{U}^{n_1}(1-P_{U})^{n-n_1} = \alpha /2}
}
