\name{cdai_score}
\alias{cdai_score}
\title{
Crohn's Disease Activity Index (CDAI)
}
\description{
Calculates the Crohn's Disease Activity Index (CDAI), the gold standard for assessing disease severity in clinical studies of Crohn's disease. The score is based on 8 weighted factors collected over a 7-day period, including stool frequency, pain, general well-being, and specific laboratory/clinical findings.
}
\usage{
cdai_score(liquid_stools_sum_7d, abdominal_pain_sum_7d, well_being_sum_7d,
           complications_count, antidiarrheal_use, abdominal_mass,
           hematocrit, weight_kg, standard_weight_kg, sex)
}
\arguments{
  \item{liquid_stools_sum_7d}{
Numeric. Sum of the number of liquid or soft stools for each of the last 7 days.
}
  \item{abdominal_pain_sum_7d}{
Numeric. Sum of daily abdominal pain ratings for the last 7 days (0=None, 1=Mild, 2=Moderate, 3=Severe).
}
  \item{well_being_sum_7d}{
Numeric. Sum of daily general well-being ratings for the last 7 days (0=Generally well, 1=Slightly under par, 2=Poor, 3=Very poor, 4=Terrible).
}
  \item{complications_count}{
Numeric. Count of extra-intestinal complications present (e.g., Arthritis, Iritis, Erythema nodosum, Pyoderma gangrenosum, Anal fissure/fistula, Other fistula, Fever >37.8C).
}
  \item{antidiarrheal_use}{
Numeric (0 or 1). Use of antidiarrheal drugs (e.g., loperamide) for diarrhea. (1 = Yes).
}
  \item{abdominal_mass}{
Numeric (0, 2, or 5). Physical exam finding. 0 = None, 2 = Questionable, 5 = Definite.
}
  \item{hematocrit}{
Numeric. Current Hematocrit (\%). The score adds 6 points per percent deviation from standard (Male: 47, Female: 42).
}
  \item{weight_kg}{
Numeric. Current body weight in kg.
}
  \item{standard_weight_kg}{
Numeric. Standard body weight for height/sex in kg.
}
  \item{sex}{
String. "male" or "female". Used for Hematocrit standardization.
}
}
\value{
A list containing:
\item{CDAI_Score}{The calculated total score (Range 0 to >600).}
\item{Disease_Activity}{Classification (Remission <150, Mild 150-219, Moderate 220-450, Severe >450).}
}
\references{
Best WR, Becktel JM, Singleton JW, Kern F Jr. Development of a Crohn's disease activity index. National Cooperative Crohn's Disease Study. Gastroenterology. 1976;70(3):439-444.
}
\examples{

# Example 1: Moderate Disease
# 20 stools total (7 days), Pain sum 10, Well-being sum 10, 1 Complication,
# Antidiarrheals yes, No mass, Hct 40 (Male -> 47-40=7), Weight 70 (Std 75 -> ~6.7% dev)
# Score = (20*2) + (10*5) + (10*7) + (1*20) + 30 + 0 + (7*6) + 6.7 = ~268.7
cdai_score(20, 10, 10, 1, 1, 0, 40, 70, 75, "male")

# Example 2: Remission
# 7 stools total, Pain sum 0, Well-being sum 0, No complications, No meds,
# No mass, Hct 42 (Female -> 0), Weight 60 (Std 60 -> 0)
# Score = 14 + 0 + 0 + 0 + 0 + 0 + 0 + 0 = 14
cdai_score(7, 0, 0, 0, 0, 0, 42, 60, 60, "female")
}
