\name{ehmrg_mortality_score}
\alias{ehmrg_mortality_score}
\title{
Emergency Heart Failure Mortality Risk Grade (EHMRG)
}
\description{
Calculates the EHMRG score to predict 7-day mortality in patients presenting to the Emergency Department with acute heart failure. The score integrates vital signs, age, renal function, potassium, troponin status, and active cancer history to risk-stratify patients for disposition decisions (discharge vs. admission).
}
\usage{
ehmrg_mortality_score(age, sbp, heart_rate, o2_sat, creatinine, potassium,
                      troponin_positive, active_cancer, creatinine_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sbp}{
Numeric. Systolic Blood Pressure (mmHg). (Lower SBP increases risk).
}
  \item{heart_rate}{
Numeric. Heart rate (bpm). (Higher HR increases risk).
}
  \item{o2_sat}{
Numeric. Oxygen saturation (\%). (Lower saturation increases risk).
}
  \item{creatinine}{
Numeric. Serum Creatinine.
}
  \item{potassium}{
Numeric. Serum Potassium (mEq/L).
}
  \item{troponin_positive}{
Numeric (0 or 1). Positive Troponin result. (1 = Yes).
}
  \item{active_cancer}{
Numeric (0 or 1). Active cancer history. (1 = Yes).
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "micromol/L".
}
}
\value{
A list containing:
\item{EHMRG_Score}{The calculated risk score.}
\item{Risk_Classification}{Risk tier (Low, Intermediate, High, Very High).}
\item{Est_7_Day_Mortality}{Estimated 7-day mortality risk.}
}
\references{
Lee DS, Stitt A, Austin PC, et al. Prediction of heart failure mortality in emergent care: a cohort study. Ann Intern Med. 2012;156(11):767-775. doi:10.7326/0003-4819-156-11-201206050-00003
}
\examples{

# Example 1: High Risk
# 85yo, SBP 100, HR 110, O2 88, Cr 2.0, K 4.8, Trop Pos, Cancer Yes
ehmrg_mortality_score(85, 100, 110, 88, 2.0, 4.8, 1, 1)

# Example 2: Low Risk
# 50yo, SBP 150, HR 70, O2 98, Cr 0.9, K 3.8, Trop Neg, No Cancer
ehmrg_mortality_score(50, 150, 70, 98, 0.9, 3.8, 0, 0)
}
