\name{hacks_impairment_index}
\alias{hacks_impairment_index}
\title{
HACKS Impairment Index (HII)
}
\description{
Calculates the HACKS Impairment Index score to screen for frailty and predict the risk of institutionalization and mortality in older adults. The acronym HACKS stands for: Hearing loss, ADL/IADL impairment, Cognitive impairment, K(C)omorbidity, and Slow gait (though specific items have evolved in validation studies to the 6 used here: Gait Speed, SPPB/Physical Performance, Cognition, Incontinence, ADL, IADL).
}
\usage{
hacks_impairment_index(gait_speed_lt_0_8, physical_performance_lt_10,
                       mmse_lt_26, incontinence, adl_impairment,
                       iadl_impairment)
}
\arguments{
  \item{gait_speed_lt_0_8}{
Numeric (0 or 1). Gait speed < 0.8 m/s. (1 = Yes, +1 point).
}
  \item{physical_performance_lt_10}{
Numeric (0 or 1). Short Physical Performance Battery (SPPB) score < 10. (1 = Yes, +1 point).
}
  \item{mmse_lt_26}{
Numeric (0 or 1). MMSE score < 26. (1 = Yes, +1 point).
}
  \item{incontinence}{
Numeric (0 or 1). Presence of urinary incontinence. (1 = Yes, +1 point).
}
  \item{adl_impairment}{
Numeric (0 or 1). Impairment in at least one Activity of Daily Living (ADL). (1 = Yes, +1 point).
}
  \item{iadl_impairment}{
Numeric (0 or 1). Impairment in at least one Instrumental Activity of Daily Living (IADL). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{HII_Score}{The calculated total score (Range 0-6).}
\item{Impairment_Level}{Classification (No, Mild, Severe Impairment).}
\item{Institutionalization_Risk}{Estimated risk category.}
}
\references{
Jankovic D, et al. The HACKS impairment index: a simple screening tool for frailty and adverse outcomes in older adults. (Contextual reference based on tool description).
}
\examples{

# Example 1: Severe Impairment
# Slow gait (+1), SPPB<10 (+1), MMSE<26 (+1), ADL (+1)
# Score = 4
hacks_impairment_index(1, 1, 1, 0, 1, 0)

# Example 2: No Impairment
# All normal
hacks_impairment_index(0, 0, 0, 0, 0, 0)
}
