\name{pcdai_score}
\alias{pcdai_score}
\title{
Pediatric Crohn's Disease Activity Index (PCDAI)
}
\description{
Calculates the PCDAI score to assess disease activity in pediatric patients with Crohn's disease. The score ranges from 0 to 100, with higher scores indicating more active disease. It integrates subjective reporting, physical examination findings, and laboratory values (Hematocrit, ESR, Albumin).
}
\usage{
pcdai_score(abdominal_pain_score, stool_frequency_score, general_wellbeing_score,
            weight_score, height_score, abdominal_exam_score,
            perirectal_disease_score, extraintestinal_manifestations_score,
            hematocrit, esr, albumin_g_dl, age_years, sex)
}
\arguments{
  \item{abdominal_pain_score}{Numeric. 0: None; 5: Mild; 10: Moderate/Severe.}
  \item{stool_frequency_score}{Numeric. 0: 0-1 liquid stools/day; 5: 2-5 liquid stools/day; 10: >=6 liquid stools/day or nocturnal.}
  \item{general_wellbeing_score}{Numeric. 0: No limitation; 5: Occasional limitation; 10: Frequent limitation.}
  \item{weight_score}{Numeric. 0: Weight gain or voluntary loss/stable; 5: Weight stable (if growing) or involuntary loss <10\%; 10: Weight loss >=10\%.}
  \item{height_score}{Numeric. 0: <1 channel decrease; 5: >=1 channel decrease; 10: >=2 channel decrease.}
  \item{abdominal_exam_score}{Numeric. 0: No tenderness/mass; 5: Tenderness or mass; 10: Tenderness/guarding or definite mass.}
  \item{perirectal_disease_score}{Numeric. 0: None/asymptomatic tags; 5: 1-2 indolent fistula/scant drainage/abscess; 10: Active fistula/drainage/tenderness/abscess.}
  \item{extraintestinal_manifestations_score}{Numeric. 0: None; 5: 1 manifestation; 10: >=2 manifestations (Fever >38.5C for 3 days, Arthritis, Uveitis, E. Nodosum, P. Gangrenosum, Stomatitis).}
  \item{hematocrit}{Numeric. Hematocrit percentage.}
  \item{esr}{Numeric. Erythrocyte Sedimentation Rate (mm/hr).}
  \item{albumin_g_dl}{Numeric. Serum Albumin (g/dL).}
  \item{age_years}{Numeric. Patient age in years (used for Hematocrit scoring).}
  \item{sex}{String. "Male" or "Female" (used for Hematocrit scoring).}
}
\value{
A list containing:
\item{PCDAI_Score}{The calculated total score.}
\item{Disease_Activity}{Classification (Inactive <10, Mild 10-30, Moderate/Severe >30).}
\item{Lab_Points}{Breakdown of points contributed by laboratory values.}
}
\references{
Hyams JS, et al. Development and validation of a pediatric Crohn's disease activity index. J Pediatr Gastroenterol Nutr. 1991;12(4):439-447.
}
\examples{
# Example 1: Severe Disease
# Pain(10), Stool(10), Well(10), Wt(10), Ht(10), Abd(10), Peri(10), Extra(10),
# Low Hct (11y Male, Hct 30 -> 5pts), ESR 50 (5pts), Alb 2.5 (10pts)
pcdai_score(10, 10, 10, 10, 10, 10, 10, 10, 30, 50, 2.5, 11, "male")

# Example 2: Remission
# All 0s, Normal Labs
pcdai_score(0, 0, 0, 0, 0, 0, 0, 0, 40, 10, 4.0, 12, "female")
}
