\name{revised_original_aih_score}
\alias{revised_original_aih_score}
\title{
Revised Original Score for Autoimmune Hepatitis (1999)
}
\description{
Calculates the 1999 Revised Original Score (International Autoimmune Hepatitis Group) for the diagnosis of Autoimmune Hepatitis (AIH). This comprehensive scoring system evaluates biochemical ratios, autoantibodies, viral markers, histology, and history to classify patients as having Probable or Definite AIH.
}
\usage{
revised_original_aih_score(sex, alp_ast_ratio, globulin_igg_ratio,
                           autoantibody_titer, ama_positive,
                           viral_markers_positive, drug_history_positive,
                           alcohol_intake_low, histology_interface,
                           histology_plasma_cells, histology_rosettes,
                           histology_biliary, other_immune_disease,
                           hla_dr3_dr4, treatment_response = "none")
}
\arguments{
  \item{sex}{
String. "female" (+2 pts) or "male" (0 pts).
}
  \item{alp_ast_ratio}{
Numeric. Ratio of Alkaline Phosphatase to AST (relative to ULN). (<1.5: +2, 1.5-3.0: 0, >3.0: -2).
}
  \item{globulin_igg_ratio}{
Numeric. Ratio of Serum Globulins (or IgG) to the Upper Limit of Normal. (>2.0: +3, 1.5-2.0: +2, 1.0-1.5: +1, <1.0: 0).
}
  \item{autoantibody_titer}{
String. Titer of ANA, SMA, or Anti-LKM1. Options: "gt_1_80" (>1:80, +3), "1_80" (1:80, +2), "1_40" (1:40, +1), "lt_1_40" (<1:40, 0).
}
  \item{ama_positive}{
Numeric (0 or 1). Antimitochondrial Antibody positive? (1 = Yes, -4 pts).
}
  \item{viral_markers_positive}{
Numeric (0 or 1). Positive markers for active Hepatitis A, B, or C? (1 = Yes, -3 pts; 0 = No, +3 pts).
}
  \item{drug_history_positive}{
Numeric (0 or 1). History of hepatotoxic drug use? (1 = Yes, -4 pts; 0 = No, +1 pt).
}
  \item{alcohol_intake_low}{
Numeric (0 or 1). Average alcohol intake < 25 g/day? (1 = Yes, +2 pts; 0 = No, -2 pts).
}
  \item{histology_interface}{
Numeric (0 or 1). Interface hepatitis (piecemeal necrosis)? (1 = Yes, +3 pts).
}
  \item{histology_plasma_cells}{
Numeric (0 or 1). Predominantly lymphoplasmacytic infiltrate? (1 = Yes, +1 pt).
}
  \item{histology_rosettes}{
Numeric (0 or 1). Liver cell rosettes? (1 = Yes, +1 pt).
}
  \item{histology_biliary}{
Numeric (0 or 1). Biliary changes? (1 = Yes, -3 pts). (Note: If histology "None of above" is present, that is -5 pts, usually captured by entering 0 for all specific positives).
}
  \item{other_immune_disease}{
Numeric (0 or 1). Presence of other autoimmune diseases? (1 = Yes, +2 pts).
}
  \item{hla_dr3_dr4}{
Numeric (0 or 1). HLA DR3 or DR4 present? (1 = Yes, +1 pt).
}
  \item{treatment_response}{
String. Response to therapy (optional for pre-treatment score). "none" (0), "complete" (remission, +2), "relapse" (relapse after cessation, +3).
}
}
\value{
A list containing:
\item{AIH_Score}{The calculated total score.}
\item{Diagnosis}{Diagnostic classification (Definite >15, Probable 10-15, Unlikely <10).}
}
\references{
Alvarez F, Berg PA, Bianchi FB, et al. International Autoimmune Hepatitis Group Report: review of criteria for diagnosis of autoimmune hepatitis. J Hepatol. 1999;31(5):929-938. doi:10.1016/s0168-8278(99)80297-9
}
\examples{

# Example 1: Definite AIH
# Female (+2), Low ALP ratio (+2), High IgG (+3), ANA 1:160 (+3), No viral/drugs/alcohol (+3+1+2)
# Interface (+3), Plasma (+1)
# Score = 2+2+3+3+3+1+2+3+1 = 20
revised_original_aih_score("female", 1.0, 2.5, "gt_1_80", 0, 0, 0, 1, 1, 1, 0, 0, 0, 0)

# Example 2: AIH Unlikely
# Male (0), Viral Pos (-3), Alcohol High (-2), Histology Biliary (-3)
# Score = -8 + baseline factors
revised_original_aih_score("male", 2.0, 1.0, "lt_1_40", 0, 1, 0, 0, 0, 0, 0, 1, 0, 0)
}
