\name{wexner_ods_score}
\alias{wexner_ods_score}
\title{
Wexner Score for Obstructed Defecation Syndrome (ODS)
}
\description{
Calculates the Wexner Constipation Score (also known as the Agachan-Wexner Score) for evaluating the severity of constipation and Obstructed Defecation Syndrome. The score ranges from 0 to 30 (though often modified versions like the ODS-specific subset sum to 20 or similar, this function assumes standard item summation as per the original validation for constipation severity).
}
\usage{
wexner_ods_score(bowel_movement_frequency, straining,
                 sensation_incomplete_evacuation, use_of_enemas_laxatives,
                 abdominal_pain, time_per_attempt_minutes,
                 assistance_needed_per_attempt, unsuccessful_attempts_per_24h)
}
\arguments{
  \item{bowel_movement_frequency}{
Numeric (0-2 or 0-4 depending on scale variant). Frequency of bowel movements.
}
  \item{straining}{
Numeric (0-4). Frequency of straining (Never to Always).
}
  \item{sensation_incomplete_evacuation}{
Numeric (0-4). Frequency of incomplete evacuation sensation.
}
  \item{use_of_enemas_laxatives}{
Numeric (0-2). Use of enemas or laxatives.
}
  \item{abdominal_pain}{
Numeric (0-4). Frequency of abdominal pain.
}
  \item{time_per_attempt_minutes}{
Numeric (0-4). Duration of time in lavatory per attempt.
}
  \item{assistance_needed_per_attempt}{
Numeric (0-2). Type of assistance needed (None, Digitation, Enema).
}
  \item{unsuccessful_attempts_per_24h}{
Numeric (0-4). Number of unsuccessful attempts at evacuation per 24 hours.
}
}
\value{
A list containing:
\item{Wexner_ODS_Score}{The calculated total score.}
\item{Interpretation}{General interpretation guide.}
}
\references{
Agachan F, Chen T, Pfeifer J, Reissman P, Wexner SD. A constipation scoring system to simplify evaluation and management of constipated patients. Dis Colon Rectum. 1996;39(6):681-685. doi:10.1007/bf02056950
}
\examples{

# Example 1: Severe ODS
# Freq(1), Strain(4), Incomplete(4), Laxatives(2), Pain(3), Time(4), Assist(2), Unsuccessful(4)
# Score = 24
wexner_ods_score(1, 4, 4, 2, 3, 4, 2, 4)

# Example 2: Mild
# All 0s
wexner_ods_score(0, 0, 0, 0, 0, 0, 0, 0)
}
