% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrselect-package.R
\docType{package}
\name{corrselect-package}
\alias{corrselect-package}
\alias{corrselect}
\title{corrselect: Correlation-Based and Model-Based Predictor Pruning}
\description{
Provides tools for reducing multicollinearity in predictor sets through
association-based and model-based approaches. The package offers both fast
greedy algorithms for quick pruning and exact graph-theoretic algorithms
for exhaustive subset enumeration.
}
\section{Association-Based Pruning}{

These functions identify variable subsets where all pairwise correlations
or associations remain below a user-defined threshold:
\describe{
\item{\code{\link{corrPrune}}}{Fast greedy pruning for numeric data}
\item{\code{\link{corrSelect}}}{Exhaustive enumeration for numeric data frames}
\item{\code{\link{assocSelect}}}{Exhaustive enumeration for mixed-type data (numeric, factor, ordered)}
\item{\code{\link{MatSelect}}}{Direct interface using a pre-computed correlation matrix}
}
}

\section{Model-Based Pruning}{

These functions use variance inflation factors (VIF) to iteratively remove
collinear predictors from regression models:
\describe{
\item{\code{\link{modelPrune}}}{VIF-based pruning for lm, glm, lme4, and glmmTMB models}
}
}

\section{Algorithms}{

The exact enumeration functions (\code{corrSelect}, \code{assocSelect},
\code{MatSelect}) use two graph-theoretic algorithms:
\describe{
\item{Eppstein-Loffler-Strash (ELS)}{Recommended when using \code{force_in} constraints}
\item{Bron-Kerbosch}{Default algorithm, with optional pivoting for performance}
}
}

\section{Helpers}{

\describe{
\item{\code{\link{corrSubset}}}{Extract specific subsets from results}
\item{\code{\link{CorrCombo-class}}}{S4 class holding enumeration results}
}
}

\seealso{
Vignettes: \code{vignette("quickstart", package = "corrselect")},
\code{vignette("advanced", package = "corrselect")}
}
\author{
\strong{Maintainer}: Gilles Colling \email{gilles.colling051@gmail.com}

}
