% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestMaxGainSamples-class}
\alias{NextBestMaxGainSamples-class}
\alias{.NextBestMaxGainSamples}
\alias{NextBestMaxGainSamples}
\alias{.DefaultNextBestMaxGainSamples}
\title{\code{NextBestMaxGainSamples}}
\usage{
NextBestMaxGainSamples(prob_target_drt, prob_target_eot, derive, mg_derive)

.DefaultNextBestMaxGainSamples()
}
\arguments{
\item{prob_target_drt}{(\code{proportion})\cr see slot definition in \code{\link{NextBestMaxGain}}.}

\item{prob_target_eot}{(\code{proportion})\cr see slot definition in \code{\link{NextBestMaxGain}}.}

\item{derive}{(\code{function})\cr see slot definition.}

\item{mg_derive}{(\code{function})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{NextBestMaxGainSamples}} is the class to find a next best dose with maximum
gain value based on a pseudo DLT and efficacy models and DLT and efficacy
samples. There are two target probabilities of the occurrence of a DLT that
must be specified: target probability to be used during the trial and target
probability to be used at the end of the trial.
It is suitable to use it only with the \code{\link{ModelTox}} model and \code{\link{ModelEff}}
classes.
}
\section{Slots}{

\describe{
\item{\code{derive}}{(\code{function})\cr derives, based on a vector of posterior dose
samples, the target dose that has the probability of the occurrence of
DLT equals to either the \code{prob_target_drt} or \code{prob_target_eot}. It must
therefore accept one and only one argument, which is a numeric vector, and
return a number.}

\item{\code{mg_derive}}{(\code{function})\cr derives, based on a vector of posterior dose
samples that give the maximum gain value, the final next best estimate of
the dose that gives the maximum gain value. It must therefore accept one
and only one argument, which is a numeric vector, and return a number.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestMaxGainSamples()} function.
}
\examples{
# Target probability of the occurrence of a DLT during the trial is set to 0.35.
# Target probability of the occurrence of a DLT at the end of the trial is set to 0.3.
# We want the use the 30\% posterior quantile (the 30th percentile) of the TD35
# (the dose level with probability of the DLT equals 0.35) and TD30 samples.
# For `mg_derive` function (which takes the sample of doses which give the maximum
# gain), we will use the 50\% posterior quantile (the median or th 50th percentile)
# of the sample.
my_next_best <- NextBestMaxGainSamples(
  prob_target_drt = 0.35,
  prob_target_eot = 0.3,
  derive = function(samples) {
    as.numeric(quantile(samples, prob = 0.3))
  },
  mg_derive = function(mg_samples) {
    as.numeric(quantile(mg_samples, prob = 0.5))
  }
)
}
