% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-fancyFileInput.R
\name{observeDirectoryProgress}
\alias{observeDirectoryProgress}
\title{Enable progress tracking for directory uploads}
\usage{
observeDirectoryProgress(inputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{the input ID of the \code{fancyDirectoryInput}}

\item{session}{the Shiny session object (default: \code{shiny::getDefaultReactiveDomain()})}
}
\value{
invisible NULL; sets up reactive observers for progress tracking
}
\description{
Helper function to set up progress tracking using \code{\link{progress2}}
for \code{\link{fancyDirectoryInput}}. Call this in your server function
to enable automatic progress updates.
}
\examples{
\dontrun{
server <- function(input, output, session) {
  # Enable progress tracking
  observeDirectoryProgress("dir_input")

  # Your other server logic...
}
}
}
