% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daFitFunctions.r
\name{da.clm.fit}
\alias{da.clm.fit}
\title{Provides fit indices for ordinal regression models, based on the Nagelkerke (1991) method.}
\usage{
da.clm.fit(original.model, newdata = NULL, ...)
}
\arguments{
\item{original.model}{Original fitted model}

\item{newdata}{Data used in update statement}

\item{...}{ignored}
}
\value{
A function described by \link{using-fit-indices} description for interface.
        You could retrieve \code{r2.n} index, corresponding to Nagelkerke method.
}
\description{
Provides fit indices for ordinal regression models, based on the Nagelkerke (1991) method.
}
\references{
\itemize{
\item Nagelkerke, N. J. D. (1991). A Note on a General Definition of the Coefficient of Determination. Biometrika, 78(3), 691-692. doi:10.1093/biomet/78.3.691
}
}
\seealso{
Other fit indices: 
\code{\link{da.betareg.fit}()},
\code{\link{da.dynlm.fit}()},
\code{\link{da.glm.fit}()},
\code{\link{da.lm.fit}()},
\code{\link{da.lmWithCov.fit}()},
\code{\link{da.lmerMod.fit}()},
\code{\link{da.mlmWithCov.fit}()}
}
\concept{fit indices}
