% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{invert_rules}
\alias{invert_rules}
\title{invert_rules inverts a set of encoding rules.}
\usage{
invert_rules(x)
}
\arguments{
\item{x}{The rules used for encoding a message
(as a named vector).}
}
\value{
A character vector.
}
\description{
\code{invert_rules} allows decoding messages that were 
encoded by a set of rules \code{x}.
}
\details{
\code{x} is assumed to be a named vector. 

\code{invert_rules} replaces the elements of \code{x} 
by the names of \code{x}, and vice versa.

A message is issued if the elements of \code{x} are repeated 
(i.e., decoding is non-unique).
}
\examples{
invert_rules(l33t_rul35)  # Note repeated elements

# Encoding and decoding a message:
(txt_0 <- "Hello world! How are you doing today?")             # message
(txt_1 <- transl33t(txt_0, rules = l33t_rul35))                # encoding 
(txt_2 <- transl33t(txt_1, rules = invert_rules(l33t_rul35)))  # decoding

}
\seealso{
\code{\link{transl33t}} for encoding text (e.g., into leet slang);  
\code{\link{l33t_rul35}} for default rules used.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
