% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps_imt.R
\name{kgaps_imt}
\alias{kgaps_imt}
\title{Information matrix test under the \eqn{K}-gaps model}
\usage{
kgaps_imt(data, u, k = 1, inc_cens = TRUE)
}
\arguments{
\item{data}{A numeric vector or numeric matrix of raw data.  If \code{data}
  is a matrix then the log-likelihood is constructed as the sum of
  (independent) contributions from different columns. A common situation is
  where each column relates to a different year.

  If \code{data} contains missing values then \code{\link{split_by_NAs}} is
  used to divide the data into sequences of non-missing values.}

\item{u, k}{Numeric vectors.  \code{u} is a vector of extreme value
  thresholds applied to data.  \code{k} is a vector of values of the run
  parameter \eqn{K}, as defined in Suveges and Davison (2010).
  See \code{\link{kgaps}} for more details.

  Any values in \code{u} that are greater than all the observations in
  \code{data} will be removed without a warning being given.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from censored inter-exceedance times, relating to the
first and last observations.  See Attalides (2015) for details.}
}
\value{
An object (a list) of class \code{c("kgaps_imt", "exdex")}
  containing
  \item{imt }{A \code{length(u)} by \code{length(k)} numeric matrix.
    Column i contains, for \eqn{K} = \code{k[i]}, the values of the
    information matrix test statistic for the set of thresholds in
    \code{u}.  The column names are the values in \code{k}.
    The row names are the approximate empirical percentage quantile levels
    of the thresholds in \code{u}.}
  \item{p }{A \code{length(u)} by \code{length(k)} numeric matrix
    containing the corresponding \eqn{p}-values for the test.}
  \item{theta }{A \code{length(u)} by \code{length(k)} numeric matrix
    containing the corresponding estimates of \eqn{\theta}.}
  \item{u,k }{The input \code{u} and \code{k}.}
}
\description{
Performs the information matrix test (IMT) of Suveges and Davison (2010) to
diagnose misspecification of the \eqn{K}-gaps model.
}
\details{
The \eqn{K}-gaps IMT is performed a over grid of all
  combinations of threshold and \eqn{K} in the vectors \code{u}
  and \code{k}.  If the estimate of \eqn{\theta} is 0 then the
  IMT statistic, and its associated \eqn{p}-value is \code{NA}.

  For details of the IMT see Suveges and Davison
  (2010).  There are some typing errors on pages 18-19 that have been
  corrected in producing the code: the penultimate term inside \code{{...}}
  in the middle equation on page 18 should be \eqn{(c_j(K))^2}, as should
  the penultimate term in the first equation on page 19; the \code{{...}}
  bracket should be squared in the 4th equation on page 19; the factor
  \eqn{n} should be \eqn{N-1} in the final equation on page 19.
}
\examples{
### Newlyn sea surges

u <- quantile(newlyn, probs = seq(0.1, 0.9, by = 0.1))
imt <- kgaps_imt(newlyn, u = u, k = 1:5)

### S&P 500 index

u <- quantile(sp500, probs = seq(0.1, 0.9, by = 0.1))
imt <- kgaps_imt(sp500, u = u, k = 1:5)

### Cheeseboro wind gusts (a matrix containing some NAs)

probs <- c(seq(0.5, 0.98, by = 0.025), 0.99)
u <- quantile(cheeseboro, probs = probs, na.rm = TRUE)
imt <- kgaps_imt(cheeseboro, u = u, k = 1:5)
}
\references{
Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \doi{10.1214/09-AOAS292}

Attalides, N. (2015) Threshold-based extreme value modelling,
  PhD thesis, University College London.
  \url{https://discovery.ucl.ac.uk/1471121/1/Nicolas_Attalides_Thesis.pdf}
}
\seealso{
\code{\link{kgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{choose_uk}} for graphical diagnostic to aid the choice
  of the threshold \eqn{u} and the run parameter \eqn{K}.
}
