% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-lpfilt.R
\name{lpfilt}
\alias{lpfilt}
\title{Lowpass filtering of time series data}
\usage{
lpfilt(
  eyeris,
  wp = 4,
  ws = 8,
  rp = 1,
  rs = 35,
  plot_freqz = FALSE,
  call_info = NULL
)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}}

\item{wp}{The end of passband frequency in Hz (desired lowpass cutoff).
Defaults to \code{4}}

\item{ws}{The start of stopband frequency in Hz (required lowpass cutoff).
Defaults to \code{8}}

\item{rp}{Required maximal ripple within passband in dB. Defaults to \code{1}}

\item{rs}{Required minimal attenuation within stopband in dB.
Defaults to \code{35}}

\item{plot_freqz}{A flag to indicate whether to display the filter frequency
response. Defaults to \code{FALSE}}

\item{call_info}{A list of call information and parameters. If not provided,
it will be generated from the function call. Defaults to \code{NULL}}
}
\value{
An \code{eyeris} object with a new column in \verb{time series}:
\verb{pupil_raw_\{...\}_lpfilt}
}
\description{
The intended use of this method is for smoothing, although by specifying
\code{wp} and \code{ws} differently one can achieve highpass or bandpass filtering
as well. However, only lowpass filtering should be done on pupillometry data.
}
\details{
This function is automatically called by \code{glassbox()} by default. If needed,
customize the parameters for \code{lpfilt} by providing a parameter list. Use
\code{glassbox(lpfilt = FALSE)} to disable this step as needed.

Users should prefer using \code{glassbox()} rather than invoking this function
directly unless they have a specific reason to customize the pipeline
manually.
}
\note{
This function is part of the \code{glassbox()} preprocessing pipeline and is not
intended for direct use in most cases. Provide parameters via
\code{lpfilt = list(...)}.

Advanced users may call it directly if needed.
}
\examples{
demo_data <- eyelink_asc_demo_dataset()

demo_data |>
  # set lpfilt to FALSE (instead of a list of params) to skip step
  eyeris::glassbox(lpfilt = list(plot_freqz = TRUE)) |>
  plot(seed = 0)

}
\seealso{
\code{\link[=glassbox]{glassbox()}} for the recommended way to run this step as
part of the full eyeris glassbox preprocessing pipeline
}
