% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_tibble.R
\name{new_tbl}
\alias{new_tbl}
\alias{f_enframe}
\alias{f_deframe}
\alias{as_tbl}
\title{Fast 'tibble' alternatives}
\usage{
new_tbl(..., .nrows = NULL, .recycle = TRUE, .name_repair = TRUE)

f_enframe(x, name = "name", value = "value")

f_deframe(x)

as_tbl(x)
}
\arguments{
\item{...}{Dynamic name-value pairs.}

\item{.nrows}{\code{integer(1)} (Optional) number of rows. \cr
Commonly used to initialise a 0-column data frame with rows.}

\item{.recycle}{\code{logical(1)} Should arguments be recycled?
Default is \code{FALSE}.}

\item{.name_repair}{\code{logical(1)} Should duplicate names be made unique?
Default is \code{TRUE}.}

\item{x}{A data frame or vector.}

\item{name}{\code{character(1)} Name to use for column of names.}

\item{value}{\code{character(1)} Name to use for column of values.}
}
\value{
A tibble or vector.
}
\description{
Fast 'tibble' alternatives
}
\details{
\code{new_tbl} and \code{as_tbl} are alternatives to
\code{tibble} and \code{as_tibble} respectively.

\code{f_enframe(x)} where \code{x} is a \code{data.frame} converts \code{x} into a tibble
of column names and list-values.
}
