% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{felt_delete_map_elements}
\alias{felt_delete_map_elements}
\title{Delete an existing element}
\usage{
felt_delete_map_elements(map_id, element_id)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{element_id}{element identifier, as returned by \code{felt_get_map_elements()} or \code{felt_add_map_elements()}}
}
\value{
response code
}
\description{
Delete an existing element
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
elem <- felt_add_map_elements(map_id = 'Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA',
                    elements = fs::path_package('feltr',  'bbox.geojson'))
elem
# and delete layer
felt_delete_map_elements(map_id = 'TBI8sDkmQjuK2GX9CSiHiUA', element_id = elem$felt_id)
\dontshow{\}) # examplesIf}
}
